/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.jdbcx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Stack;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.h2.upgrade.v1_1.jdbcx.JdbcDataSource;

public class JdbcConnectionPool
implements DataSource {
    private static final int DEFAULT_TIMEOUT = 300;
    private final ConnectionPoolDataSource dataSource;
    private final Stack<PooledConnection> recycledConnections = new Stack();
    private final PoolConnectionEventListener poolConnectionEventListener = new PoolConnectionEventListener();
    private PrintWriter logWriter;
    private int maxConnections = 10;
    private int timeout = 300;
    private int activeConnections;
    private boolean isDisposed;

    private JdbcConnectionPool(ConnectionPoolDataSource connectionPoolDataSource) {
        this.dataSource = connectionPoolDataSource;
        try {
            this.logWriter = connectionPoolDataSource.getLogWriter();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static JdbcConnectionPool create(ConnectionPoolDataSource connectionPoolDataSource) {
        return new JdbcConnectionPool(connectionPoolDataSource);
    }

    public static JdbcConnectionPool create(String string, String string2, String string3) {
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        jdbcDataSource.setURL(string);
        jdbcDataSource.setUser(string2);
        jdbcDataSource.setPassword(string3);
        return new JdbcConnectionPool(jdbcDataSource);
    }

    public synchronized void setMaxConnections(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid maxConnections value: " + n);
        }
        this.maxConnections = n;
        this.notifyAll();
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    public synchronized int getLoginTimeout() {
        return this.timeout;
    }

    public synchronized void setLoginTimeout(int n) {
        if (n == 0) {
            n = 300;
        }
        this.timeout = n;
    }

    public synchronized void dispose() throws SQLException {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        SQLException sQLException = null;
        while (!this.recycledConnections.isEmpty()) {
            PooledConnection pooledConnection = this.recycledConnections.pop();
            try {
                pooledConnection.close();
            }
            catch (SQLException sQLException2) {
                if (sQLException != null) continue;
                sQLException = sQLException2;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        int n = 0;
        while (true) {
            JdbcConnectionPool jdbcConnectionPool = this;
            synchronized (jdbcConnectionPool) {
                if (this.activeConnections < this.maxConnections) {
                    return this.getConnectionNow();
                }
                if (n >= this.timeout) {
                    throw new SQLException("Login timeout", "08001", 8001);
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    private Connection getConnectionNow() throws SQLException {
        if (this.isDisposed) {
            throw new IllegalStateException("Connection pool has been disposed.");
        }
        PooledConnection pooledConnection = !this.recycledConnections.empty() ? this.recycledConnections.pop() : this.dataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        ++this.activeConnections;
        pooledConnection.addConnectionEventListener(this.poolConnectionEventListener);
        return connection;
    }

    synchronized void recycleConnection(PooledConnection pooledConnection) {
        if (this.isDisposed) {
            this.disposeConnection(pooledConnection);
            return;
        }
        if (this.activeConnections <= 0) {
            throw new AssertionError();
        }
        --this.activeConnections;
        if (this.activeConnections < this.maxConnections) {
            this.recycledConnections.push(pooledConnection);
        } else {
            this.closeConnection(pooledConnection);
        }
        this.notifyAll();
    }

    private void closeConnection(PooledConnection pooledConnection) {
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            this.log("Error while closing database connection: " + sQLException.toString());
        }
    }

    synchronized void disposeConnection(PooledConnection pooledConnection) {
        if (this.activeConnections <= 0) {
            throw new AssertionError();
        }
        --this.activeConnections;
        this.notifyAll();
        this.closeConnection(pooledConnection);
    }

    private void log(String string) {
        String string2 = this.getClass().getName() + ": " + string;
        try {
            if (this.logWriter == null) {
                System.err.println(string2);
            } else {
                this.logWriter.println(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized int getActiveConnections() {
        return this.activeConnections;
    }

    public Connection getConnection(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    class PoolConnectionEventListener
    implements ConnectionEventListener {
        PoolConnectionEventListener() {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            pooledConnection.removeConnectionEventListener(this);
            JdbcConnectionPool.this.recycleConnection(pooledConnection);
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
            pooledConnection.removeConnectionEventListener(this);
            JdbcConnectionPool.this.disposeConnection(pooledConnection);
        }
    }
}

