/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.message;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.h2.upgrade.v1_1.constant.ErrorCode;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.jdbc.JdbcSQLException;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.message.Trace;
import org.h2.upgrade.v1_1.message.TraceWriter;
import org.h2.upgrade.v1_1.util.ClassUtils;
import org.h2.upgrade.v1_1.util.FileUtils;
import org.h2.upgrade.v1_1.util.IOUtils;
import org.h2.upgrade.v1_1.util.SmallLRUCache;

public class TraceSystem
implements TraceWriter {
    public static final int PARENT = -1;
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int ADAPTER = 4;
    public static final int DEFAULT_TRACE_LEVEL_SYSTEM_OUT = 0;
    public static final int DEFAULT_TRACE_LEVEL_FILE = 1;
    private static final int DEFAULT_MAX_FILE_SIZE = 0x4000000;
    private static final int CHECK_SIZE_EACH_WRITES = 128;
    private int levelSystemOut = 0;
    private int levelFile = 1;
    private int levelMax;
    private int maxFileSize = 0x4000000;
    private String fileName;
    private SmallLRUCache<String, Trace> traces;
    private SimpleDateFormat dateFormat;
    private Writer fileWriter;
    private PrintWriter printWriter;
    private int checkSize;
    private boolean closed;
    private boolean writingErrorLogged;
    private TraceWriter writer = this;

    public TraceSystem(String string) {
        this.fileName = string;
        this.updateLevel();
        this.traces = SmallLRUCache.newInstance(100);
    }

    private void updateLevel() {
        this.levelMax = Math.max(this.levelSystemOut, this.levelFile);
    }

    public static void traceThrowable(Throwable throwable) {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            throwable.printStackTrace(printWriter);
        }
    }

    public synchronized Trace getTrace(String string) {
        Trace trace = (Trace)this.traces.get(string);
        if (trace == null) {
            trace = new Trace(this.writer, string);
            this.traces.put(string, trace);
        }
        return trace;
    }

    public boolean isEnabled(int n) {
        return n <= this.levelMax;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setMaxFileSize(int n) {
        this.maxFileSize = n;
    }

    public void setLevelSystemOut(int n) {
        this.levelSystemOut = n;
        this.updateLevel();
    }

    public int getLevelSystemOut() {
        return this.levelSystemOut;
    }

    public void setLevelFile(int n) {
        if (n == 4) {
            String string = "org.h2.upgrade.v1_1.message.TraceWriterAdapter";
            try {
                this.writer = (TraceWriter)ClassUtils.loadSystemClass(string).newInstance();
            }
            catch (Throwable throwable) {
                JdbcSQLException jdbcSQLException = Message.getSQLException(90086, throwable, string);
                this.write(1, "database", string, jdbcSQLException);
                return;
            }
            String string2 = this.fileName;
            if (string2 != null) {
                int n2;
                if (string2.endsWith(".trace.db")) {
                    string2 = string2.substring(0, string2.length() - ".trace.db".length());
                }
                if ((n2 = Math.max(string2.lastIndexOf(47), string2.lastIndexOf(92))) >= 0) {
                    string2 = string2.substring(n2 + 1);
                }
                this.writer.setName(string2);
            }
        }
        this.levelFile = n;
        this.updateLevel();
    }

    public int getLevelFile() {
        return this.levelFile;
    }

    private synchronized String format(String string, String string2) {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss ");
        }
        return this.dateFormat.format(new Date()) + string + ": " + string2;
    }

    public void write(int n, String string, String string2, Throwable throwable) {
        if (n <= this.levelSystemOut || n > this.levelMax) {
            System.out.println(this.format(string, string2));
            if (throwable != null && this.levelSystemOut == 3) {
                throwable.printStackTrace();
            }
        }
        if (this.fileName != null && n <= this.levelFile) {
            this.writeFile(this.format(string, string2), throwable);
        }
    }

    private synchronized void writeFile(String string, Throwable throwable) {
        try {
            Object object;
            if (this.checkSize++ >= 128) {
                this.checkSize = 0;
                this.closeWriter();
                if (this.maxFileSize > 0 && FileUtils.length(this.fileName) > (long)this.maxFileSize) {
                    object = this.fileName + ".old";
                    if (FileUtils.exists((String)object)) {
                        FileUtils.delete((String)object);
                    }
                    FileUtils.rename(this.fileName, (String)object);
                }
            }
            if (!this.openWriter()) {
                return;
            }
            this.printWriter.println(string);
            if (throwable != null) {
                if (this.levelFile == 1 && throwable instanceof JdbcSQLException) {
                    object = (JdbcSQLException)throwable;
                    int n = ((SQLException)object).getErrorCode();
                    if (ErrorCode.isCommon(n)) {
                        this.printWriter.println(throwable.toString());
                    } else {
                        throwable.printStackTrace(this.printWriter);
                    }
                } else {
                    throwable.printStackTrace(this.printWriter);
                }
            }
            this.printWriter.flush();
            if (this.closed) {
                this.closeWriter();
            }
        }
        catch (Exception exception) {
            this.logWritingError(exception);
        }
    }

    private void logWritingError(Exception exception) {
        if (this.writingErrorLogged) {
            return;
        }
        this.writingErrorLogged = true;
        JdbcSQLException jdbcSQLException = Message.getSQLException(90034, exception, this.fileName, exception.toString());
        this.fileName = null;
        System.out.println(jdbcSQLException);
        ((Throwable)jdbcSQLException).printStackTrace();
    }

    private boolean openWriter() {
        if (this.printWriter == null) {
            try {
                FileUtils.createDirs(this.fileName);
                if (FileUtils.exists(this.fileName) && FileUtils.isReadOnly(this.fileName)) {
                    return false;
                }
                this.fileWriter = IOUtils.getWriter(FileUtils.openFileOutputStream(this.fileName, true));
                this.printWriter = new PrintWriter(this.fileWriter, true);
            }
            catch (Exception exception) {
                this.logWritingError(exception);
                return false;
            }
        }
        return true;
    }

    private synchronized void closeWriter() {
        if (this.printWriter != null) {
            this.printWriter.flush();
            this.printWriter.close();
            this.printWriter = null;
        }
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileWriter = null;
        }
    }

    public void close() {
        this.closeWriter();
        this.closed = true;
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        this.close();
    }

    public void setName(String string) {
    }
}

