/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.security;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.security.AES;
import org.h2.upgrade.v1_1.security.BlockCipher;
import org.h2.upgrade.v1_1.security.SHA256;
import org.h2.upgrade.v1_1.security.XTEA;

public class CipherFactory {
    private CipherFactory() {
    }

    public static BlockCipher getBlockCipher(String string) throws SQLException {
        if ("XTEA".equalsIgnoreCase(string)) {
            return new XTEA();
        }
        if ("AES".equalsIgnoreCase(string)) {
            return new AES();
        }
        throw Message.getSQLException(90055, string);
    }

    public static SHA256 getHash(String string) throws SQLException {
        if ("SHA256".equalsIgnoreCase(string)) {
            return new SHA256();
        }
        throw Message.getInvalidValueException(string, "algorithm");
    }
}

