/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.store.FileLister;
import org.h2.upgrade.v1_1.util.FileUtils;
import org.h2.upgrade.v1_1.util.IOUtils;
import org.h2.upgrade.v1_1.util.Tool;

public class Restore
extends Tool {
    public static void main(String ... stringArray) throws SQLException {
        new Restore().run(stringArray);
    }

    public void run(String ... stringArray) throws SQLException {
        String string = "backup.zip";
        String string2 = ".";
        String string3 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.equals("-dir")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string4.equals("-file")) {
                string = stringArray[++i];
                continue;
            }
            if (string4.equals("-db")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string4.equals("-quiet")) continue;
            if (string4.equals("-help") || string4.equals("-?")) {
                this.showUsage();
                return;
            }
            this.throwUnsupportedOption(string4);
        }
        this.process(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOriginalDbName(String string, String string2) throws IOException {
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry;
            inputStream = FileUtils.openFileInputStream(string);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            String string3 = null;
            boolean bl = false;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string4 = zipEntry.getName();
                zipInputStream.closeEntry();
                String string5 = FileLister.getDatabaseNameFromFileName(string4);
                if (string5 == null) continue;
                if (string2.equals(string5)) {
                    string3 = string5;
                    break;
                }
                if (string3 == null) {
                    string3 = string5;
                    continue;
                }
                bl = true;
            }
            zipInputStream.close();
            if (bl && !string2.equals(string3)) {
                throw new IOException("Multiple databases found, but not " + string2);
            }
            zipEntry = string3;
            return zipEntry;
        }
        finally {
            IOUtils.closeSilently(inputStream);
        }
    }

    public static void execute(String string, String string2, String string3, boolean bl) throws SQLException {
        new Restore().process(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String string, String string2, String string3) throws SQLException {
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry;
            if (!FileUtils.exists(string)) {
                throw new IOException("File not found: " + string);
            }
            String string4 = null;
            int n = 0;
            if (string3 != null) {
                string4 = Restore.getOriginalDbName(string, string3);
                if (string4 == null) {
                    throw new IOException("No database named " + string3 + " found");
                }
                if (string4.startsWith(File.separator)) {
                    string4 = string4.substring(1);
                }
                n = string4.length();
            }
            inputStream = FileUtils.openFileInputStream(string);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string5 = zipEntry.getName();
                string5 = string5.replace('\\', File.separatorChar);
                if ((string5 = string5.replace('/', File.separatorChar)).startsWith(File.separator)) {
                    string5 = string5.substring(1);
                }
                boolean bl = false;
                if (string3 == null) {
                    bl = true;
                } else if (string5.startsWith(string4 + ".")) {
                    string5 = string3 + string5.substring(n);
                    bl = true;
                }
                if (bl) {
                    OutputStream outputStream = null;
                    try {
                        outputStream = FileUtils.openFileOutputStream(string2 + File.separator + string5, false);
                        IOUtils.copy(zipInputStream, outputStream);
                        outputStream.close();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeSilently(outputStream);
                        throw throwable;
                    }
                    IOUtils.closeSilently(outputStream);
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
        }
        catch (IOException iOException) {
            try {
                throw Message.convertIOException(iOException, string);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeSilently(inputStream);
    }
}

