/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.util;

import java.util.Comparator;
import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.util.MathUtils;
import org.h2.upgrade.v1_1.util.ObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheObject {
    public CacheObject cachePrevious;
    public CacheObject cacheNext;
    public CacheObject cacheChained;
    public int cacheQueue;
    protected int blockCount;
    private int pos;
    private boolean changed;

    public abstract boolean canRemove();

    public static void sort(ObjectArray<CacheObject> objectArray) {
        objectArray.sort(new CacheComparator());
    }

    public void setBlockCount(int n) {
        this.blockCount = n;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setPos(int n) {
        if (SysProperties.CHECK && (this.cachePrevious != null || this.cacheNext != null || this.cacheChained != null)) {
            Message.throwInternalError("setPos too late");
        }
        this.pos = n;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public boolean isPinned() {
        return false;
    }

    public int getMemorySize() {
        return this.blockCount * 32;
    }

    static {
        new CacheComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheComparator
    implements Comparator<CacheObject> {
        CacheComparator() {
        }

        @Override
        public int compare(CacheObject cacheObject, CacheObject cacheObject2) {
            return MathUtils.compare(cacheObject.getPos(), cacheObject2.getPos());
        }
    }
}

