/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.util;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.h2.upgrade.v1_1.message.Message;

public class MathUtils {
    private MathUtils() {
    }

    public static int roundUp(int n, int n2) {
        return n + n2 - 1 & -n2;
    }

    public static long roundUpLong(long l, long l2) {
        return l + l2 - 1L & -l2;
    }

    public static void checkPowerOf2(int n) {
        if ((n & n - 1) != 0 && n > 0) {
            Message.throwInternalError("not a power of 2: " + n);
        }
    }

    public static int nextPowerOf2(int n) {
        long l;
        for (l = 1L; l < (long)n && l < 0x3FFFFFFFL; l += l) {
        }
        return (int)l;
    }

    public static long scaleUp50Percent(long l, long l2, long l3, long l4) {
        long l5;
        if (l2 > l4 * 2L) {
            l5 = MathUtils.roundUpLong(l2, l4);
        } else {
            for (l5 = l; l5 < l2; l5 += l5 % l3) {
                l5 += l5 / 2L;
            }
        }
        return l5;
    }

    public static BigDecimal setScale(BigDecimal bigDecimal, int n) throws SQLException {
        if (n > 100000) {
            throw Message.getInvalidValueException("" + n, "scale");
        }
        if (n < -100000) {
            throw Message.getInvalidValueException("" + n, "scale");
        }
        return bigDecimal.setScale(n, 4);
    }

    public static byte decodeByte(String string) {
        return Byte.decode(string);
    }

    public static short decodeShort(String string) {
        return Short.decode(string);
    }

    public static int decodeInt(String string) {
        return Integer.decode(string);
    }

    public static long decodeLong(String string) {
        return Long.decode(string);
    }

    public static int convertLongToInt(long l) {
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public static int reverse(int n) {
        n = (n & 0x55555555) << 1 | n >>> 1 & 0x55555555;
        n = (n & 0x33333333) << 2 | n >>> 2 & 0x33333333;
        n = (n & 0xF0F0F0F) << 4 | n >>> 4 & 0xF0F0F0F;
        n = n << 24 | (n & 0xFF00) << 8 | n >>> 8 & 0xFF00 | n >>> 24;
        return n;
    }

    public static long reverse(long l) {
        return (long)MathUtils.reverse((int)(l >>> 32)) & 0xFFFFFFFFL ^ (long)MathUtils.reverse((int)l) << 32;
    }

    public static int compare(int n, int n2) {
        return n == n2 ? 0 : (n < n2 ? -1 : 1);
    }

    public static int compare(long l, long l2) {
        return l == l2 ? 0 : (l < l2 ? -1 : 1);
    }
}

