/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.util;

public class MemoryUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static long lastGC;
    private static final int GC_DELAY = 50;
    private static final int MAX_GC = 8;

    private MemoryUtils() {
    }

    public static int getMemoryUsed() {
        MemoryUtils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        return (int)(l >> 10);
    }

    public static int getMemoryFree() {
        MemoryUtils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        return (int)(l >> 10);
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = System.currentTimeMillis();
        if (lastGC + 50L < l2) {
            for (int i = 0; i < 8; ++i) {
                runtime.gc();
                long l3 = runtime.totalMemory();
                if (l3 == l) {
                    lastGC = System.currentTimeMillis();
                    break;
                }
                l = l3;
            }
        }
    }

    public static byte[] newBytes(int n) {
        try {
            if (n == 0) {
                return EMPTY_BYTES;
            }
            return new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Requested memory: " + n);
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public static int[] newIntArray(int n) {
        if (n == 0) {
            return EMPTY_INT_ARRAY;
        }
        return new int[n];
    }

    public static long[] newLongArray(int n) {
        if (n == 0) {
            return EMPTY_LONG_ARRAY;
        }
        return new long[n];
    }
}

