/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.util;

import java.sql.SQLException;
import org.h2.upgrade.v1_1.message.Message;
import org.h2.upgrade.v1_1.store.DataHandler;
import org.h2.upgrade.v1_1.util.HashBase;
import org.h2.upgrade.v1_1.util.ObjectArray;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueHashMap<V>
extends HashBase {
    private Value[] keys;
    private V[] values;
    private DataHandler handler;

    private ValueHashMap(DataHandler dataHandler) {
        this.handler = dataHandler;
    }

    public static <T> ValueHashMap<T> newInstance(DataHandler dataHandler) {
        return new ValueHashMap(dataHandler);
    }

    @Override
    protected void reset(int n) {
        super.reset(n);
        this.keys = new Value[this.len];
        this.values = new Object[this.len];
    }

    @Override
    protected void rehash(int n) throws SQLException {
        Value[] valueArray = this.keys;
        V[] VArray = this.values;
        this.reset(n);
        for (int i = 0; i < valueArray.length; ++i) {
            Value value = valueArray[i];
            if (value == null || value == ValueNull.DELETED) continue;
            this.put(value, VArray[i]);
        }
    }

    private int getIndex(Value value) {
        return value.hashCode() & this.mask;
    }

    public void put(Value value, V v) throws SQLException {
        this.checkSizePut();
        int n = this.getIndex(value);
        int n2 = 1;
        int n3 = -1;
        do {
            Value value2;
            if ((value2 = this.keys[n]) == null) {
                if (n3 >= 0) {
                    n = n3;
                    --this.deletedCount;
                }
                ++this.size;
                this.keys[n] = value;
                this.values[n] = v;
                return;
            }
            if (value2 == ValueNull.DELETED) {
                if (n3 < 0) {
                    n3 = n;
                }
            } else if (this.handler.compareTypeSave(value2, value) == 0) {
                this.values[n] = v;
                return;
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        Message.throwInternalError("hashmap is full");
    }

    public void remove(Value value) throws SQLException {
        this.checkSizeRemove();
        int n = this.getIndex(value);
        int n2 = 1;
        do {
            Value value2;
            if ((value2 = this.keys[n]) == null) {
                return;
            }
            if (value2 != ValueNull.DELETED && this.handler.compareTypeSave(value2, value) == 0) {
                this.keys[n] = ValueNull.DELETED;
                this.values[n] = null;
                ++this.deletedCount;
                --this.size;
                return;
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
    }

    public V get(Value value) throws SQLException {
        int n = this.getIndex(value);
        int n2 = 1;
        do {
            Value value2;
            if ((value2 = this.keys[n]) == null) {
                return null;
            }
            if (value2 != ValueNull.DELETED && this.handler.compareTypeSave(value2, value) == 0) {
                return this.values[n];
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        return null;
    }

    public ObjectArray<Value> keys() {
        ObjectArray<Value> objectArray = ObjectArray.newInstance(this.size);
        for (Value value : this.keys) {
            if (value == null || value == ValueNull.DELETED) continue;
            objectArray.add(value);
        }
        return objectArray;
    }

    public ObjectArray<V> values() {
        ObjectArray<V> objectArray = ObjectArray.newInstance(this.size);
        for (int i = 0; i < this.keys.length; ++i) {
            Value value = this.keys[i];
            if (value == null || value == ValueNull.DELETED) continue;
            objectArray.add(this.values[i]);
        }
        return objectArray;
    }
}

