/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade.v1_1.value;

import org.h2.upgrade.v1_1.constant.SysProperties;
import org.h2.upgrade.v1_1.util.MathUtils;
import org.h2.upgrade.v1_1.util.StringCache;
import org.h2.upgrade.v1_1.value.CompareMode;
import org.h2.upgrade.v1_1.value.Value;
import org.h2.upgrade.v1_1.value.ValueStringBase;

public class ValueStringFixed
extends ValueStringBase {
    private static final ValueStringFixed EMPTY = new ValueStringFixed("");

    protected ValueStringFixed(String string) {
        super(string);
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueStringBase valueStringBase = (ValueStringBase)value;
        return compareMode.compareString(this.value, valueStringBase.value, false);
    }

    private static String trimRight(String string) {
        int n;
        int n2;
        for (n2 = n = string.length() - 1; n2 >= 0 && string.charAt(n2) == ' '; --n2) {
        }
        string = n2 == n ? string : string.substring(0, n2 + 1);
        return string;
    }

    public boolean equals(Object object) {
        return object instanceof ValueStringBase && this.value.equals(((ValueStringBase)object).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int getType() {
        return 21;
    }

    public static ValueStringFixed get(String string) {
        if ((string = ValueStringFixed.trimRight(string)).length() == 0) {
            return EMPTY;
        }
        ValueStringFixed valueStringFixed = new ValueStringFixed(StringCache.get(string));
        if (string.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueStringFixed;
        }
        return (ValueStringFixed)Value.cache(valueStringFixed);
    }

    public Value convertPrecision(long l) {
        if (l == 0L || (long)this.value.length() <= l) {
            return this;
        }
        int n = MathUtils.convertLongToInt(l);
        return ValueStringFixed.get(this.value.substring(0, n));
    }
}

