/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.dockable.AbstractDockable;
import bibliothek.gui.dock.dockable.DockableBackgroundComponent;
import bibliothek.gui.dock.dockable.DockableIcon;
import bibliothek.gui.dock.dockable.IconHandling;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.LayoutFocusTraversalPolicy;

public class DefaultDockable
extends AbstractDockable {
    private BackgroundPanel pane = new ConfiguredBackgroundPanel((LayoutManager)new BorderLayout(), Transparency.SOLID);
    private String factoryId = "DefaultDockableFactory";
    private Background background = new Background();
    private WeakReference<Component> clientComponent;

    public DefaultDockable() {
        this(null, null, null, IconHandling.REPLACE_NULL_ICON);
    }

    public DefaultDockable(Icon icon) {
        this(null, null, icon, IconHandling.KEEP_NULL_ICON);
    }

    public DefaultDockable(String title) {
        this(null, title, null, IconHandling.REPLACE_NULL_ICON);
    }

    public DefaultDockable(Component component) {
        this(component, null, null, IconHandling.REPLACE_NULL_ICON);
    }

    public DefaultDockable(Component component, Icon icon) {
        this(component, null, icon, IconHandling.KEEP_NULL_ICON);
    }

    public DefaultDockable(Component component, String title) {
        this(component, title, null, IconHandling.REPLACE_NULL_ICON);
    }

    public DefaultDockable(Component component, String title, Icon icon) {
        this(component, title, icon, IconHandling.KEEP_NULL_ICON);
    }

    public DefaultDockable(Component component, String title, Icon icon, IconHandling handling) {
        super(PropertyKey.DOCKABLE_TITLE, PropertyKey.DOCKABLE_TOOLTIP);
        this.pane.setFocusable(false);
        this.pane.setFocusTraversalPolicyProvider(true);
        this.pane.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.pane.setBackground(this.background);
        if (component != null) {
            this.clientComponent = new WeakReference<Component>(component);
            this.getContentPane().setLayout(new GridLayout(1, 1));
            this.getContentPane().add(component);
        }
        this.setTitleIconHandling(handling);
        this.setTitleIcon(icon);
        this.setTitleText(title);
    }

    @Override
    protected DockIcon createTitleIcon() {
        return new DockableIcon("dockable.default", this){

            @Override
            protected void changed(Icon oldValue, Icon newValue) {
                DefaultDockable.this.fireTitleIconChanged(oldValue, newValue);
            }
        };
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler(this){

            @Override
            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                if (component == DefaultDockable.this.getContentPane()) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE_CHILDREN;
                }
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    @Override
    public String getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryID(String factoryId) {
        if (factoryId == null) {
            throw new IllegalArgumentException("FactoryID must not be null");
        }
        this.factoryId = factoryId;
    }

    @Override
    public Component getComponent() {
        return this.pane;
    }

    @Override
    public DockStation asDockStation() {
        return null;
    }

    public int getComponentCount() {
        return this.getContentPane().getComponentCount();
    }

    public Component getComponent(int index) {
        return this.getContentPane().getComponent(index);
    }

    public Component getClientComponent() {
        if (this.clientComponent == null) {
            return null;
        }
        Component child = (Component)this.clientComponent.get();
        if (child == null) {
            this.clientComponent = null;
            return null;
        }
        if (child.getParent() != this.getContentPane()) {
            this.clientComponent = null;
            return null;
        }
        return child;
    }

    public Container getContentPane() {
        return this.pane;
    }

    public void add(Component component) {
        this.getContentPane().add(component);
    }

    public void add(Component component, Object constraints) {
        this.getContentPane().add(component, constraints);
    }

    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    public void setLayout(LayoutManager layout) {
        this.getContentPane().setLayout(layout);
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        this.background.setController(controller);
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockableBackgroundComponent {
        public Background() {
            super(DockableBackgroundComponent.KIND, "dock.background.dockable");
        }

        @Override
        public Component getComponent() {
            return this.getDockable().getComponent();
        }

        @Override
        public Dockable getDockable() {
            return DefaultDockable.this;
        }
    }
}

