/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.action.actions.AbstractStandardDockAction;
import bibliothek.gui.dock.action.actions.GroupKeyGenerator;
import bibliothek.gui.dock.action.actions.SimpleDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.util.container.Tuple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class GroupedDockAction<K, D extends SimpleDockAction>
extends AbstractStandardDockAction {
    private Map<K, D> groups = new HashMap<K, D>();
    private Map<Dockable, Tuple<K, D>> dockActions = new HashMap<Dockable, Tuple<K, D>>();
    private Listener listener = new Listener();
    private boolean removeEmptyGroups = true;
    private GroupKeyGenerator<? extends K> generator;

    public GroupedDockAction(GroupKeyGenerator<? extends K> generator) {
        super(true);
        this.generator = generator;
    }

    public void setGenerator(GroupKeyGenerator<? extends K> generator) {
        this.generator = generator;
    }

    public GroupKeyGenerator<? extends K> getGenerator() {
        return this.generator;
    }

    public boolean isRemoveEmptyGroups() {
        return this.removeEmptyGroups;
    }

    public void setRemoveEmptyGroups(boolean removeEmptyGroups) {
        this.removeEmptyGroups = removeEmptyGroups;
    }

    @Override
    public Icon getIcon(Dockable dockable, ActionContentModifier modifier) {
        return ((SimpleDockAction)this.getGroup(dockable)).getIcon(dockable, modifier);
    }

    @Override
    public ActionContentModifier[] getIconContexts(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getIconContexts(dockable);
    }

    @Override
    public String getText(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getText(dockable);
    }

    @Override
    public String getTooltipText(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getTooltipText(dockable);
    }

    @Override
    public boolean isEnabled(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).isEnabled(dockable) && super.isEnabled(dockable);
    }

    @Override
    public void bound(Dockable dockable) {
        K key = this.createGroupKey(dockable);
        if (key == null) {
            throw new IllegalStateException("null-key generated, a null-key is not allowed");
        }
        super.bound(dockable);
        D action = this.ensureGroup(key);
        ((AbstractStandardDockAction)action).bind(dockable);
        this.dockActions.put(dockable, new Tuple<K, D>(key, action));
    }

    @Override
    public void unbound(Dockable dockable) {
        super.unbound(dockable);
        Tuple<K, D> action = this.dockActions.remove(dockable);
        ((SimpleDockAction)action.getB()).unbind(dockable);
        this.removeIfEmpty(action.getA());
    }

    private void removeIfEmpty(K key) {
        D group;
        if (this.removeEmptyGroups && ((AbstractStandardDockAction)(group = this.getGroup(key))).getBoundDockables().isEmpty()) {
            this.groups.remove(key);
            ((AbstractStandardDockAction)group).removeDockActionListener(this.listener);
        }
    }

    public void setIcon(K key, Icon icon) {
        ((SimpleDockAction)this.ensureGroup(key)).setIcon(icon);
    }

    public Icon getIcon(Object key) {
        SimpleDockAction action = (SimpleDockAction)this.groups.get(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getIcon();
    }

    public void setIcon(K key, ActionContentModifier modifier, Icon icon) {
        ((SimpleDockAction)this.ensureGroup(key)).setIcon(modifier, icon);
    }

    public Icon getIcon(Object key, ActionContentModifier modifier) {
        SimpleDockAction action = (SimpleDockAction)this.groups.get(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getIcon(modifier);
    }

    public void setDisabledIcon(K key, Icon icon) {
        ((SimpleDockAction)this.ensureGroup(key)).setDisabledIcon(icon);
    }

    public Icon getDisabledIcon(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getDisabledIcon();
    }

    public Icon getDisabledIcon(Object key) {
        SimpleDockAction action = (SimpleDockAction)this.groups.get(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getDisabledIcon();
    }

    public void setText(K key, String text) {
        ((SimpleDockAction)this.ensureGroup(key)).setText(text);
    }

    public String getText(Object key) {
        SimpleDockAction action = (SimpleDockAction)this.groups.get(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getText();
    }

    public void setTooltip(K key, String text) {
        ((SimpleDockAction)this.ensureGroup(key)).setTooltip(text);
    }

    public String getTooltipText(Object key) {
        SimpleDockAction action = (SimpleDockAction)this.groups.get(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getTooltipText();
    }

    public String getTooltip(Object key) {
        SimpleDockAction action = (SimpleDockAction)this.groups.get(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getTooltip();
    }

    public void setEnabled(K key, boolean enabled) {
        ((SimpleDockAction)this.ensureGroup(key)).setEnabled(enabled);
    }

    public boolean isEnabled(Object key) {
        D action = this.getGroup(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return ((SimpleDockAction)action).isEnabled();
    }

    @Override
    public Dockable getDockableRepresentation(Dockable dockable) {
        return ((SimpleDockAction)this.getGroup(dockable)).getDockableRepresentation(dockable);
    }

    public Dockable getDockableRepresentation(K key) {
        SimpleDockAction action = (SimpleDockAction)this.groups.get(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getDockableRepresentation();
    }

    public void setDockableRepresentation(K key, Dockable dockable) {
        ((SimpleDockAction)this.ensureGroup(key)).setDockableRepresentation(dockable);
    }

    public void setAccelerator(K key, KeyStroke accelerator) {
        ((SimpleDockAction)this.ensureGroup(key)).setAccelerator(accelerator);
    }

    public KeyStroke getAccelerator(K key) {
        SimpleDockAction action = (SimpleDockAction)this.groups.get(key);
        if (action == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return action.getAccelerator();
    }

    protected D ensureGroup(K key) {
        if (key == null) {
            throw new IllegalArgumentException("The key must be a non-null value");
        }
        SimpleDockAction action = (SimpleDockAction)this.groups.get(key);
        if (action == null) {
            action = this.createGroup(key);
            action.addDockActionListener(this.listener);
            this.groups.put(key, action);
        }
        return (D)action;
    }

    protected D getGroup(Dockable dockable) {
        Tuple<K, D> group = this.dockActions.get(dockable);
        return (D)(group == null ? null : (SimpleDockAction)group.getB());
    }

    protected D getGroup(Object key) {
        return (D)((SimpleDockAction)this.groups.get(key));
    }

    protected abstract D createGroup(K var1);

    public boolean groupExists(Object key) {
        return this.groups.containsKey(key);
    }

    public boolean removeGroup(Object key) {
        SimpleDockAction group = (SimpleDockAction)this.groups.get(key);
        if (group == null) {
            return true;
        }
        if (group.getBoundDockables().isEmpty()) {
            group.removeDockActionListener(this.listener);
            this.groups.remove(key);
            return true;
        }
        return false;
    }

    protected K createGroupKey(Dockable dockable) {
        return this.generator.generateKey(dockable);
    }

    public void setGroup(K key, Dockable dockable) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        Tuple<K, D> old = this.dockActions.get(dockable);
        if (old == null) {
            throw new IllegalArgumentException("Dockable was not registered");
        }
        D put = this.ensureGroup(key);
        ((SimpleDockAction)old.getB()).unbind(dockable);
        this.removeIfEmpty(old.getA());
        ((AbstractStandardDockAction)put).bind(dockable);
        this.dockActions.put(dockable, new Tuple<K, D>(key, put));
        HashSet<Dockable> set = new HashSet<Dockable>();
        set.add(dockable);
        this.fireActionEnabledChanged(set);
        this.fireActionIconChanged(null, set);
        this.fireActionTextChanged(set);
        this.fireActionTooltipTextChanged(set);
        this.fireActionRepresentativeChanged(set);
    }

    public boolean isKnown(Dockable dockable) {
        return this.dockActions.containsKey(dockable);
    }

    @Override
    public boolean trigger(Dockable dockable) {
        return this.getGroup(dockable).trigger(dockable);
    }

    private class Listener
    implements StandardDockActionListener {
        private Listener() {
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            GroupedDockAction.this.fireActionTooltipTextChanged(dockables);
        }

        @Override
        public void actionTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            GroupedDockAction.this.fireActionTextChanged(dockables);
        }

        @Override
        public void actionIconChanged(StandardDockAction action, ActionContentModifier modifier, Set<Dockable> dockables) {
            GroupedDockAction.this.fireActionIconChanged(modifier, dockables);
        }

        @Override
        public void actionEnabledChanged(StandardDockAction action, Set<Dockable> dockables) {
            GroupedDockAction.this.fireActionEnabledChanged(dockables);
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction action, Set<Dockable> dockables) {
            GroupedDockAction.this.fireActionRepresentativeChanged(dockables);
        }
    }
}

