/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.Enforcement;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ThemeCombiner
implements Combiner {
    private DockController controller;

    public ThemeCombiner(DockController controller) {
        this.controller = controller;
    }

    private Combiner get(CombinerSource source) {
        return this.get(source.getParent());
    }

    private Combiner get(DockStation station) {
        return this.controller.getTheme().getCombiner(station);
    }

    @Override
    public CombinerTarget prepare(CombinerSource source, Enforcement force) {
        Combiner combiner = this.get(source);
        CombinerTarget delegate = combiner.prepare(source, force);
        if (delegate == null) {
            return null;
        }
        return new Target(combiner, delegate);
    }

    @Override
    public Dockable combine(CombinerSource source, CombinerTarget target) {
        Target tTarget = (Target)target;
        return tTarget.combiner.combine(source, tTarget.delegate);
    }

    @Override
    public void aside(AsideRequest request) {
        DockStation parent = request.getParentStation();
        if (parent != null) {
            Combiner combiner = this.get(parent);
            combiner.aside(request);
        }
    }

    private static class Target
    implements CombinerTarget {
        private Combiner combiner;
        private CombinerTarget delegate;

        public Target(Combiner combiner, CombinerTarget delegate) {
            this.combiner = combiner;
            this.delegate = delegate;
        }

        @Override
        public void paint(Graphics g, Component component, StationPaint paint, Rectangle stationBounds, Rectangle dockableBounds) {
            this.delegate.paint(g, component, paint, stationBounds, dockableBounds);
        }

        @Override
        public DisplayerCombinerTarget getDisplayerCombination() {
            return this.delegate.getDisplayerCombination();
        }
    }
}

