/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.j2d.rsl;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.hw.Shader;
import com.sun.scenario.effect.impl.j2d.rsl.RSLRenderer;
import java.awt.GraphicsConfiguration;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.java2d.pipe.BufferedContext;
import sun.java2d.pipe.BufferedPaints;
import sun.java2d.pipe.RenderQueue;

public abstract class RSLEffectPeer
extends EffectPeer {
    private static Field isValidatedPaintAColorField = null;
    private static Method resetPaintMethod = null;
    private static boolean initialized;

    protected RSLEffectPeer(FilterContext filterContext, Renderer renderer, String string) {
        super(filterContext, renderer, string);
    }

    public abstract void dispose();

    public final ImageData filter(Effect effect, BaseTransform baseTransform, final ImageData ... imageDataArray) {
        this.setEffect(effect);
        this.setDestBounds(this.getResultBounds(baseTransform, imageDataArray));
        return AccessController.doPrivileged(new PrivilegedAction<ImageData>(){

            @Override
            public ImageData run() {
                return RSLEffectPeer.this.filterImpl(imageDataArray);
            }
        });
    }

    abstract ImageData filterImpl(ImageData ... var1);

    protected abstract boolean isSamplerLinear(int var1);

    protected abstract Shader createShader();

    protected abstract void updateShader(Shader var1);

    protected final RSLRenderer getRenderer() {
        return (RSLRenderer)super.getRenderer();
    }

    protected final String getShaderName() {
        return this.getUniqueName();
    }

    protected final GraphicsConfiguration getGraphicsConfig() {
        return (GraphicsConfiguration)this.getFilterContext().getReferent();
    }

    static final void saveState(BufferedContext bufferedContext) {
        RSLEffectPeer.resetPaint(bufferedContext);
        bufferedContext.saveState();
    }

    static final void restoreState(BufferedContext bufferedContext) {
        RSLEffectPeer.resetPaint(bufferedContext);
        bufferedContext.restoreState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetPaint(BufferedContext bufferedContext) {
        if (!initialized) {
            try {
                Field field = BufferedContext.class.getDeclaredField("isValidatedPaintAColor");
                field.setAccessible(true);
                isValidatedPaintAColorField = field;
                Method method = BufferedPaints.class.getDeclaredMethod("resetPaint", RenderQueue.class);
                method.setAccessible(true);
                resetPaintMethod = method;
            }
            catch (Throwable throwable) {
            }
            finally {
                initialized = true;
            }
        }
        if (isValidatedPaintAColorField != null && resetPaintMethod != null) {
            try {
                resetPaintMethod.invoke(BufferedPaints.class, bufferedContext.getRenderQueue());
                isValidatedPaintAColorField.set(bufferedContext, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

