/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppkabaddi.anzeige;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sportdata.setppkabaddi.anzeige.AnzeigeControlPanel;
import org.sportdata.setppkabaddi.anzeige.components.SimpleClockComponent;
import org.sportdata.setppkabaddi.anzeige.interfaces.ITimer;
import org.sportdata.setppkabaddi.anzeige.ressource.AnzeigeResource;
import org.sportdata.setppkabaddi.anzeige.utils.GrafikDeviceUtils;
import org.sportdata.setppkabaddi.anzeige.utils.License;
import org.sportdata.setppkabaddi.anzeige.version.Version;

public class SimpleClockPanel
extends JFrame
implements ActionListener,
ITimer {
    private static final long serialVersionUID = -1003801023381257450L;
    private JPanel a;
    private SimpleClockComponent b;
    private JButton c;
    private JButton d;
    private JLabel e;
    private AnzeigeControlPanel f;
    private String g;
    private Color h;

    public SimpleClockPanel(SimpleClockComponent clock, AnzeigeControlPanel acp, String AKA_AO_LABEL, Color colorlabel, int ychange) {
        this.b = clock;
        this.f = acp;
        this.g = AKA_AO_LABEL;
        this.h = colorlabel;
        this.setTitle(Version.getCopyright() + " (" + License.getLicense() + ")");
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        this.setBounds((screenSize.width - 300) / 2, (screenSize.height - 150) / 2 + ychange, 300, 150);
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.initComponent();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SimpleClockPanel.this.stopClock();
                SimpleClockPanel.this.closeClock();
                SimpleClockPanel.this.setVisible(false);
                SimpleClockPanel.this.dispose();
            }
        });
        clock.setTimerlabel(this);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.d.requestFocus();
    }

    public void initComponent() {
        this.a = new JPanel();
        this.a.setLayout(new GridLayout(2, 1));
        this.c = new JButton(AnzeigeResource.getResourceString("general.stop"));
        this.c.addActionListener(this);
        this.d = new JButton(AnzeigeResource.getResourceString("general.close"));
        this.d.addActionListener(this);
        JLabel ltext = new JLabel(AnzeigeResource.getResourceString("general.timer"));
        JPanel pbuttons = new JPanel();
        pbuttons.add(ltext);
        pbuttons.add(this.c);
        pbuttons.add(this.d);
        this.e = new JLabel("");
        this.e.setFont(new Font("Dialog", 1, 20));
        if (this.h != null) {
            this.e.setForeground(this.h);
        }
        JPanel ptime = new JPanel();
        ptime.add(this.e);
        this.a.add(ptime);
        this.a.add(pbuttons);
        this.add(this.a);
    }

    public void stopClock() {
        this.b.stopClock();
    }

    public void closeClock() {
        this.b.setVisible(false);
        this.b.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source.equals(this.c)) {
            this.stopClock();
        }
        if (source.equals(this.d)) {
            this.stopClock();
            this.closeClock();
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void updateTimerLabel(String timestring) {
        this.e.setText(timestring);
        this.e.repaint();
        if (timestring.equals("0")) {
            this.stopClock();
            this.closeClock();
            this.setVisible(false);
            this.dispose();
        }
    }
}

