/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppkabaddi.anzeige.constants;

import java.awt.Color;
import java.awt.Font;
import org.sportdata.setppkabaddi.anzeige.properties.helper.AnzeigePropertiesHelper;

public class MainConstants {
    public static final String LOGO_BASE64 = "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";
    public static final String DISPLAY_SOFTWARE_NAME = "SET Point Panel Kabaddi";
    public static final int DISPLAY_MODE_DEFAULT_PANEL = 0;
    public static final int DISPLAY_MODE_DEFAULT = 3;
    public static final int DISPLAY_MODE_AUTOFIND = -1;
    public static final String[] DISPLAY_LABELS = new String[]{"640x480", "800x600", "1024x768", "1280x720", "1366x768", "1400x900", "1600x1024", "1900x1080"};
    public static final int[] DISPLAY_WITH = new int[]{450, 640, 800, 1024, 1280, 1366, 1400, 1600, 1900};
    public static final int[] DISPLAY_HEIGHT = new int[]{300, 480, 600, 768, 720, 768, 900, 1024, 1080};
    public static final int[] DISPLAY_SEGMENT_MIN_FACTOR = new int[]{2, 3, 4, 5, 5, 6, 6, 7, 8};
    public static final int[] DISPLAY_SEGMENT_MAX_FACTOR = new int[]{3, 3, 5, 7, 8, 8, 9, 10, 11};
    public static final Font[] DISPLAY_FONT_TICKER = new Font[]{new Font("Dialog", 1, 15), new Font("Dialog", 1, 30), new Font("Dialog", 1, 50), new Font("Dialog", 1, 70), new Font("Dialog", 1, 70), new Font("Dialog", 1, 80), new Font("Dialog", 1, 90), new Font("Dialog", 1, 90), new Font("Dialog", 1, 110)};
    public static final Font[] DISPLAY_FONT_AKAAO_TEXT = new Font[]{new Font("Dialog", 1, 20), new Font("Dialog", 1, 50), new Font("Dialog", 1, 70), new Font("Dialog", 1, 80), new Font("Dialog", 1, 80), new Font("Dialog", 1, 90), new Font("Dialog", 1, 100), new Font("Dialog", 1, 90), new Font("Dialog", 1, 100)};
    public static final Font[] DISPLAY_FONT_AKAAO_NAMES = new Font[]{new Font("Dialog", 1, 12), new Font("Dialog", 1, 15), new Font("Dialog", 1, 20), new Font("Dialog", 1, 30), new Font("Dialog", 1, 30), new Font("Dialog", 1, 35), new Font("Dialog", 1, 35), new Font("Dialog", 1, 35), new Font("Dialog", 1, 40)};
    public static final Font[] DISPLAY_FONT_AKAAO_SANKTIONS_SMALL = new Font[]{new Font("Dialog", 0, 10), new Font("Dialog", 1, 15), new Font("Dialog", 1, 20), new Font("Dialog", 0, 25), new Font("Dialog", 0, 25), new Font("Dialog", 1, 30), new Font("Dialog", 1, 30), new Font("Dialog", 1, 30), new Font("Dialog", 1, 35)};
    public static final Font[] DISPLAY_FONT_AKAAO_SANKTIONS_BIG = new Font[]{new Font("Dialog", 1, 20), new Font("Dialog", 1, 25), new Font("Dialog", 1, 30), new Font("Dialog", 1, 40), new Font("Dialog", 1, 40), new Font("Dialog", 1, 45), new Font("Dialog", 1, 50), new Font("Dialog", 1, 50), new Font("Dialog", 1, 60)};
    public static final Font[] DISPLAY_FONT_MATCHES_ROUND = new Font[]{new Font("Dialog", 1, 20), new Font("Dialog", 1, 25), new Font("Dialog", 1, 35), new Font("Dialog", 1, 50), new Font("Dialog", 1, 50), new Font("Dialog", 1, 55), new Font("Dialog", 1, 60), new Font("Dialog", 1, 60), new Font("Dialog", 1, 70)};
    public static final Font[] DISPLAY_FONT_AKAAO_LEADER_BIG = new Font[]{new Font("Dialog", 1, 30), new Font("Dialog", 1, 40), new Font("Dialog", 1, 50), new Font("Dialog", 1, 70), new Font("Dialog", 1, 70), new Font("Dialog", 1, 70), new Font("Dialog", 1, 70), new Font("Dialog", 1, 70), new Font("Dialog", 1, 90)};
    public static final int[] TICKER_DELAY = new int[]{20, 15, 12, 10, 10, 10, 7, 7, 5};
    public static final int SEGMENT_MIN_FACTOR = 5;
    public static final int SEGMENT_MAX_FACTOR = 9;
    public static final int DEFAULT_FIGHT_TIME = 1200;
    public static final int DEFAULT_EXTRA_TIME = 300;
    public static final int TONE_WARN_TIME = 11;
    public static final int ENCHOSEN_TIME = 300;
    public static final int DEFAULT_RAID_TIME = 30;
    public static final int POINTS_DIFFERENCE_WIN = 1000000;
    public static final Color BACK_COLOR = Color.BLACK;
    public static final Color BACK_COLOR_WHITE = new Color(248, 248, 248);
    public static final Color AKA_COLOR = Color.RED;
    public static final Color AO_COLOR = new Color(0, 179, 255);
    public static final String AKA_COLOR_HTML = "#ff0000";
    public static final String AO_COLOR_HTML = "#086ef8";
    public static final Color ACTIVE_COLOR = Color.YELLOW;
    public static final Color TIME_COLOR = Color.YELLOW;
    public static final Color TIME_COLOR_WHITE = Color.BLACK;
    public static final Color SANKTIONS_COLOR = Color.LIGHT_GRAY;
    public static final Color SANKTIONS_COLOR_BLACK = Color.LIGHT_GRAY;
    public static final Color SANKTIONS_COLOR_ACTIVE = Color.BLACK;
    public static final Color NAME_COLOR = new Color(236, 236, 236);
    public static final Color NAME_COLOR_WHITE = new Color(100, 100, 100);
    public static final Color TICKER_COLOR = new Color(236, 236, 236);
    public static final Color TICKER_COLOR_WHITE = new Color(100, 100, 100);
    public static final Color MATCHES_ROUND_COLOR = Color.WHITE;
    public static final Color RAID_TIME_COLOR = Color.GREEN;
    public static final String LOG_DATE_FORMAT_SHORT = "yyyy-MM-dd HH:mm:ss";
    public static final String LICENCE_DATE_FORMAT = "yyyy-MM-dd";
    public static final String UNDO_ADD_STRING = "[UNDO]";
    public static final int CLOCK_START = 0;
    public static final int CLOCK_STOP = 1;
    public static final int CLOCK_RESET = 2;
    public static final int AKA_ADD = 3;
    public static final int AKA_REMOVE = 4;
    public static final int AKA_RESET = 5;
    public static final int AO_ADD = 6;
    public static final int AO_REMOVE = 7;
    public static final int AO_RESET = 8;
    public static final int PLAYER_RED_1_REMOVE = 10;
    public static final int PLAYER_RED_2_REMOVE = 11;
    public static final int PLAYER_RED_3_REMOVE = 12;
    public static final int PLAYER_RED_4_REMOVE = 13;
    public static final int PLAYER_RED_5_REMOVE = 14;
    public static final int PLAYER_RED_6_REMOVE = 15;
    public static final int PLAYER_RED_7_REMOVE = 16;
    public static final int PLAYER_RED_1_ADD = 18;
    public static final int PLAYER_RED_2_ADD = 19;
    public static final int PLAYER_RED_3_ADD = 20;
    public static final int PLAYER_RED_4_ADD = 21;
    public static final int PLAYER_RED_5_ADD = 22;
    public static final int PLAYER_RED_6_ADD = 23;
    public static final int PLAYER_RED_7_ADD = 24;
    public static final int PLAYER_BLUE_1_REMOVE = 25;
    public static final int PLAYER_BLUE_2_REMOVE = 26;
    public static final int PLAYER_BLUE_3_REMOVE = 27;
    public static final int PLAYER_BLUE_4_REMOVE = 28;
    public static final int PLAYER_BLUE_5_REMOVE = 29;
    public static final int PLAYER_BLUE_6_REMOVE = 30;
    public static final int PLAYER_BLUE_7_REMOVE = 31;
    public static final int PLAYER_BLUE_1_ADD = 32;
    public static final int PLAYER_BLUE_2_ADD = 33;
    public static final int PLAYER_BLUE_3_ADD = 34;
    public static final int PLAYER_BLUE_4_ADD = 35;
    public static final int PLAYER_BLUE_5_ADD = 36;
    public static final int PLAYER_BLUE_6_ADD = 37;
    public static final int PLAYER_BLUE_7_ADD = 38;
    public static final int CHECK_POINTS = 41;
    public static final int TONE_SHORT = 42;
    public static final int TONE_LONG = 43;
    public static final int RESET_ALL_COMPONENTS = 44;
    public static final int CHECK_POINTS_NORMAL = 45;
    public static final int LOG_CLOCK_START = 46;
    public static final int LOG_CLOCK_STOP = 47;
    public static final int LOG_CLOCK_RESET = 48;
    public static final int LOG_POINTS_AKA_ADD = 49;
    public static final int LOG_POINTS_AKA_REMOVE = 50;
    public static final int LOG_POINTS_AO_ADD = 51;
    public static final int LOG_POINTS_AO_REMOVE = 52;
    public static final int LOG_POINTS_AKA_RESET = 53;
    public static final int LOG_POINTS_AO_RESET = 54;
    public static final int LOG_RESET_ALL = 87;
    public static final int LOG_TIME_WARN = 88;
    public static final int LOG_TIME_END = 89;
    public static final int NAMES_SET = 90;
    public static final int LOG_NAMES_SET = 91;
    public static final int NAMES_CLEAR = 92;
    public static final int LOG_NAMES_CLEAR = 93;
    public static final int UNDO_ACTION = 94;
    public static final int LOG_UNDO_ACTION = 95;
    public static final int MODE_COMPONENTS_UNREGISER = 96;
    public static final int CHANGESIDE_ACTION = 97;
    public static final int CHANGESIDE_ACTION_MAINPANEL = 98;
    public static final int CLOCK_ENCHOSEN = 111;
    public static final int LOG_CLOCK_ENCHOSEN = 112;
    public static final int ACTION_MONITOR_EVENT = 113;
    public static final int STOP_THREADS = 125;
    public static final int CHANGESIDE_ACTION_CONTROLPANEL = 126;
    public static final int NAMES_SET_LICENSE = 127;
    public static final int ROUND_NEW = 128;
    public static final int LOG_ROUND_NEW = 129;
    public static final int LOG_ROUND_ADD = 130;
    public static final int LOG_ROUND_REMOVE = 131;
    public static final int LOGO_CHANGE = 132;
    public static final int ROUNDS_NUMBER_UPDATE = 133;
    public static final int WINNER_AKA = 134;
    public static final int WINNER_AO = 135;
    public static final int AKA_ADD_CUSTOM = 136;
    public static final int AKA_REMOVE_CUSTOM = 137;
    public static final int AO_ADD_CUSTOM = 138;
    public static final int AO_REMOVE_CUSTOM = 139;
    public static final int ROUND_NEW_SIMPLE = 140;
    public static final int LOG_SCORE_INPUT = 141;
    public static final int HIDE_TIME_CHANGE = 142;
    public static final int AKA_RESET_NOLOG = 143;
    public static final int AO_RESET_NOLOG = 144;
    public static final int TIME_CHANGE = 145;
    public static final int LOG_PROTEST_AKA_START = 171;
    public static final int LOG_PROTEST_AKA_STOP = 172;
    public static final int LOG_PROTEST_AO_START = 173;
    public static final int LOG_PROTEST_AO_STOP = 174;
    public static final int PROTEST_AKA_POSITIVE = 175;
    public static final int PROTEST_AKA_NEGATIVE = 176;
    public static final int PROTEST_AO_POSITIVE = 177;
    public static final int PROTEST_AO_NEGATIVE = 178;
    public static final int PROTEST_AKA_START = 179;
    public static final int PROTEST_AO_START = 180;
    public static final int PROTEST_CHECK = 181;
    public static final int TIME_ADD = 182;
    public static final int TIME_REMOVE = 183;
    public static final int LOG_TIME_ADD = 184;
    public static final int LOG_TIME_REMOVE = 185;
    public static final int TIME_CHANGE_QS = 186;
    public static final int MATCHINFO_SAVE = 187;
    public static final int WARNING_AKA_ADD = 188;
    public static final int WARNING_AKA_REMOVE = 189;
    public static final int WARNING_AO_ADD = 190;
    public static final int WARNING_AO_REMOVE = 191;
    public static final int FOUL_AKA_ADD = 192;
    public static final int FOUL_AKA_REMOVE = 193;
    public static final int FOUL_AO_ADD = 194;
    public static final int FOUL_AO_REMOVE = 195;
    public static final int LOG_WARNING_AKA_ADD = 196;
    public static final int LOG_WARNING_AKA_REMOVE = 197;
    public static final int LOG_WARNING_AO_ADD = 198;
    public static final int LOG_WARNING_AO_REMOVE = 199;
    public static final int LOG_FOUL_AKA_ADD = 200;
    public static final int LOG_FOUL_AKA_REMOVE = 201;
    public static final int LOG_FOUL_AO_ADD = 202;
    public static final int LOG_FOUL_AO_REMOVE = 203;
    public static final int HIDE_PENALTIES_CHANGE = 204;
    public static final int RAID_CLOCK_START = 205;
    public static final int RAID_CLOCK_STOP = 206;
    public static final int RAID_CLOCK_RESET = 207;
    public static final int LOG_RAID_CLOCK_START = 208;
    public static final int LOG_RAID_CLOCK_STOP = 209;
    public static final int LOG_RAID_CLOCK_RESET = 210;
    public static final int ROUND_NEW_SIMPLE_NORESET = 211;
    public static final int GOLDEN_RAID = 212;
    public static final int GOLDEN_RAID_END = 213;
    public static final int TIME_CHANGE_RAID = 214;
    public static final int FIVE_RAID = 215;
    public static final int FIVE_RAID_END = 216;
    public static final int RAID_COUNTDOWN_AUDIO_START = 217;
    public static final int RAID_COUNTDOWN_AUDIO_STOP = 218;
    public static final int RAID_TONE_LONG = 219;
    public static final int PROTEST_AKA = 1;
    public static final int PROTEST_AO = 2;
    public static final int WINNER_POINTS_ROUND_WON = 1;
    public static final int WINNER_POINTS_TOTAL_POINTS = 2;
    public static final int TIMER_DEFAULT = 120;
    public static final int TIMER_DEFAULT_WARN = 0;
    public static final int TIMER_DEFAULT_10SEC = 10;
    public static final int TIMER_DEFAULT_WARN_10SEC = 0;
    public static final Color TIMER_DEFAULT_COLOR = new Color(255, 24, 0);
    public static final Color TIMER_DEFAULT_COLOR_WHITE = new Color(231, 22, 0);
    public static final String NAMES_SET_LICENSE_TEXT = "NO VALID LICENSE";
    public static final String AKA_LABEL_TEXT = "HOME";
    public static final String AO_LABEL_TEXT = "GUEST";
    public static final int TEXT_TICKER = 0;
    public static final int TEXT_FIXED = 1;
    public static final String[] TEXT_OPTIONS = new String[]{"Text Ticker", "Text Fixed"};
    public static final String[] SCORE_OPTIONS = new String[]{"SCORE_OUT", "SCORE_BONUS", "SCORE_ALL-OUT", "SCORE_TECHNICAL", "SCORE_OUT", "SCORE_SUPER-TACKLE"};
    public static final String[] SCORE_OPTIONS_HTML = new String[]{"<html><br><span style=\"font-size:20px; font-weight:bold;\">OUT</span><br>&nbsp;</html>", "<html><br><span style=\"font-size:20px; font-weight:bold;\">BONUS</span><br>&nbsp;</html>", "<html><br><span style=\"font-size:20px; font-weight:bold;\">ALL-OUT</span><br>&nbsp;</html>", "<html><br><span style=\"font-size:20px; font-weight:bold;\">TECHN.</span><br>&nbsp;</html>", "<html><br><span style=\"font-size:20px; font-weight:bold;\">TACKLE</span><br>&nbsp;</html>", "<html><br><span style=\"font-size:20px; font-weight:bold;\">SUPER TACKLE</span><br>&nbsp;</html>"};
    public static final String[] LANGUAGES = new String[]{"czech", "dansk", "deutsch", "english", "espanol", "francais", "italiano", "magyar", "nederlandse", "russian", "turkce", "\u4e2d\u6587", "\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", "portugu\u00eas", "c\u0440\u043f\u0441\u043a\u0438", "\u0641\u0627\u0631\u0633\u06cc", "\u0639\u0631\u0628\u0649", "rom\u00e2n\u0103"};
    public static final String[] LANGUAGES_ICONS = new String[]{"images/cz.gif", "images/den.png", "images/de.gif", "images/en.gif", "images/esp.png", "images/fr.gif", "images/ita.png", "images/hun.png", "images/ned.png", "images/rus.png", "images/tr.gif", "images/chn.png", "images/gre.png", "images/flags_small/por.png", "images/flags_small/srb.png", "images/flags_small/iri.png", "images/flags_small/ksa.png", "images/flags_small/rou.png"};
    public static final String LANGUAGE_DEUTSCH = "deutsch";
    public static final String LANGUAGE_ENGLISH = "english";
    public static final String LANGUAGE_CZECH = "czech";
    public static final String LANGUAGE_FRANCAIS = "francais";
    public static final String LANGUAGE_TURKCE = "turkce";
    public static final String LANGUAGE_MAGYAR = "magyar";
    public static final String LANGUAGE_ITALIANO = "italiano";
    public static final String LANGUAGE_RUSSIAN = "russian";
    public static final String LANGUAGE_NEDERLANDSE = "nederlandse";
    public static final String LANGUAGE_CHINESE = "\u4e2d\u6587";
    public static final String LANGUAGE_GREEK = "\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac";
    public static final String LANGUAGE_ESPANIA = "espanol";
    public static final String LANGUAGE_DANISH = "dansk";
    public static final String LANGUAGE_PORTUGUESE = "portugu\u00eas";
    public static final String LANGUAGE_SERBIAN = "c\u0440\u043f\u0441\u043a\u0438";
    public static final String LANGUAGE_PERSIAN = "\u0641\u0627\u0631\u0633\u06cc";
    public static final String LANGUAGE_ARABIC = "\u0639\u0631\u0628\u0649";
    public static final String LANGUAGE_ROMANIAN = "rom\u00e2n\u0103";
    public static final String resourceBundleDeutsch = "languages.deutsch_ppgeneric";
    public static final String resourceBundleEnglish = "languages.english_ppgeneric";
    public static final String resourceBundleCzech = "languages.czech_ppgeneric";
    public static final String resourceBundleFrancais = "languages.francais_ppgeneric";
    public static final String resourceBundleTurkce = "languages.turkce_ppgeneric";
    public static final String resourceBundleMagyar = "languages.magyar_ppgeneric";
    public static final String resourceBundleItaliano = "languages.italiano_ppgeneric";
    public static final String resourceBundleRussian = "languages.russian_ppgeneric";
    public static final String resourceBundleNederlandse = "languages.nederlandse_ppgeneric";
    public static final String resourceBundleChinese = "languages.chinese_ppgeneric";
    public static final String resourceBundleGreek = "languages.greek_ppgeneric";
    public static final String resourceBundleEspania = "languages.espanol_ppgeneric";
    public static final String resourceBundleDansk = "languages.danish_ppgeneric";
    public static final String resourceBundlePortuguese = "languages.portuguese_pp";
    public static final String resourceBundleSerbian = "languages.serbian_pp";
    public static final String resourceBundlePersian = "languages.persian_pp";
    public static final String resourceBundleArabic = "languages.arabic_pp";
    public static final String resourceBundleRomanian = "languages.romana_pp";
    public static final String SETPPVERSION_URL = "http://setopen.sportdata.org/setversion/setppgenericversion.php";
    public static final int ROUNDS_NUMBER = 2;
    public static final String[] NATIONS = AnzeigePropertiesHelper.getPpcountries().split(";");
    public static final String[] NATIONSKURZ = AnzeigePropertiesHelper.getPpcountrycodes().split(";");
    public static final Color LAYOUT_AKA_BACKGROUND = new Color(34, 19, 20);
    public static final Color LAYOUT_AO_BACKGROUND = new Color(17, 25, 41);
    public static final String TEXT_WARNINGS = "Warnings";
    public static final String TEXT_FOULS = "Fouls";
    public static final String TEXT_WARNINGS_SHORT = "WA";
    public static final String TEXT_FOULS_SHORT = "FO";
    public static final String SCORE_TYPE_BONUS = "ScoreBonus";
    public static final String SCORE_TYPE_OUT = "ScoreOut";
    public static final String SCORE_TYPE_TECH = "ScoreTech";
    public static final String SCORE_TYPE_ALLOUT = "ScoreAllOut";
    public static final String SCORE_TYPE_SUPERTACKLE = "ScoreSuperTackle";
    public static final String ROUND_PERIOD_1 = "PERIOD 1";
    public static final String ROUND_PERIOD_2 = "PERIOD 2";
    public static final String ROUND_EXTRA_TIME_1 = "EXTRA TIME 1";
    public static final String ROUND_EXTRA_TIME_2 = "EXTRA TIME 2";
    public static final String ROUND_5RAID = "5 RAID";
    public static final String ROUND_GOLDENRAID = "GOLDEN RAID";
}

