/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppsambo.anzeige.components;

import java.awt.GridLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.sportdata.setppsambo.anzeige.AnzeigeController;
import org.sportdata.setppsambo.anzeige.interfaces.IAnzeigeEventListener;
import org.sportdata.setppsambo.anzeige.log.AnzeigeLogFormatter;
import org.sportdata.setppsambo.anzeige.utils.DateUtils;

public class LogComponent
extends JPanel
implements IAnzeigeEventListener {
    private static final long serialVersionUID = -3543036327030311388L;
    private JTextArea a;
    private Logger b;
    private AnzeigeController c;
    private int d;
    private HashMap<Integer, ArrayList<Integer>> e = new HashMap();
    private HashMap<Integer, ArrayList<Integer>> f = new HashMap();
    private int g = 1;

    public LogComponent(AnzeigeController acontrol, int mode) {
        this.d = mode;
        this.c = acontrol;
        this.registerPanel();
        this.initComponent();
        this.initLogger();
    }

    @Override
    public void registerPanel() {
        this.c.getListenersLast(this.d).add(this);
    }

    public void initComponent() {
        this.setLayout(new GridLayout(1, 1));
        this.a = new JTextArea(5, 50);
        this.a.setTabSize(4);
        this.a.setLineWrap(true);
        this.a.setWrapStyleWord(true);
        this.a.setEditable(false);
        this.a.setCaretPosition(0);
        this.add(new JScrollPane(this.a));
    }

    public void initLogger() {
        try {
            this.b = Logger.getLogger(LogComponent.class.getName());
            FileHandler file = new FileHandler("log/point_panel_sambo.log", 1000000, 10, true);
            this.b.addHandler(file);
            Handler[] handlers = this.b.getHandlers();
            int i = 0;
            while (i < handlers.length) {
                handlers[i].setFormatter(new AnzeigeLogFormatter());
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(int event, String message) {
        if (event == 95) {
            this.b.info("Next is undo action " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Next is undo action " + message + "\n");
        }
        if (event == 46) {
            this.b.info("Start clock: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Start clock: " + message + "\n");
            this.c.notifyListeners(113, "Start clock: " + message);
        }
        if (event == 47) {
            this.b.info("Stop clock: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Stop clock: " + message + "\n");
        }
        if (event == 48) {
            this.b.info("Reset clock: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Reset clock: " + message + "\n");
            this.c.notifyListeners(113, "Reset clock: " + message);
        }
        if (event == 49) {
            this.b.info("RED  add point: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  add point: " + message + "\n");
            this.c.notifyListeners(113, "RED add point: " + message);
        }
        if (event == 50) {
            this.b.info("RED  remove point: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  remove point: " + message + "\n");
            this.c.notifyListeners(113, "RED remove point: " + message);
        }
        if (event == 53) {
            this.b.info("RED  reset points: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  reset points: " + message + "\n");
            this.c.notifyListeners(113, "RED reset point: " + message);
        }
        if (event == 51) {
            this.b.info("BLUE add point: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE add point: " + message + "\n");
            this.c.notifyListeners(113, "BLUE add point: " + message);
        }
        if (event == 52) {
            this.b.info("BLUE remove point: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE remove point " + message + "\n");
            this.c.notifyListeners(113, "BLUE remove point: " + message);
        }
        if (event == 54) {
            this.b.info("BLUE reset points: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE reset points " + message + "\n");
            this.c.notifyListeners(113, "BLUE reset point: " + message);
        }
        if (event == 87) {
            this.b.info("Reset all " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Reset all " + message + "\n");
            this.c.notifyListeners(113, "Reset Point Panel " + message);
            this.resetEvents();
        }
        if (event == 88) {
            this.b.info("Time warn! " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Time warn! " + message + "\n");
        }
        if (event == 89) {
            this.b.info("Out of time! " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Out of time! " + message + "\n");
        }
        if (event == 91) {
            this.b.info("Set names " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Set names " + message + "\n");
            this.c.notifyListeners(113, "Set names " + message);
        }
        if (event == 93) {
            this.b.info("Clear names " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Clear names " + message + "\n");
        }
        if (event == 97) {
            this.b.info("Change side AKA -AO " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Change side AKA -AO " + message + "\n");
        }
        if (event == 112) {
            this.b.info("Set extra time " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] Set extra time " + message + "\n");
            this.c.notifyListeners(113, "Set extra time " + message);
        }
        if (event == 136) {
            this.b.info("RED  add Warnings: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  add Warnings: " + message + "\n");
            this.c.notifyListeners(113, "RED add Warnings: " + message);
        }
        if (event == 137) {
            this.b.info("RED  remove Warnings: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  remove Warnings: " + message + "\n");
            this.c.notifyListeners(113, "RED remove Warnings: " + message);
        }
        if (event == 138) {
            this.b.info("BLUE  add Warnings: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  add Warnings: " + message + "\n");
            this.c.notifyListeners(113, "BLUE add Warnings: " + message);
        }
        if (event == 139) {
            this.b.info("BLUE  remove Warnings: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  remove Warnings: " + message + "\n");
            this.c.notifyListeners(113, "BLUE remove Warnings: " + message);
        }
        if (event == 140) {
            this.b.info("RED  add Knock-Downs: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  add Knock-Downs: " + message + "\n");
            this.c.notifyListeners(113, "RED add Knock-Downs: " + message);
        }
        if (event == 141) {
            this.b.info("RED  remove Knock-Downs: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  remove Knock-Downs: " + message + "\n");
            this.c.notifyListeners(113, "RED remove Knock-Downs: " + message);
        }
        if (event == 142) {
            this.b.info("BLUE  add Knock-Downs: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  add Knock-Downs: " + message + "\n");
            this.c.notifyListeners(113, "BLUE add Knock-Downs: " + message);
        }
        if (event == 143) {
            this.b.info("BLUE  remove Knock-Downs: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  remove Knock-Downs: " + message + "\n");
            this.c.notifyListeners(113, "BLUE remove Knock-Downs: " + message);
        }
        if (event == 146) {
            this.b.info("RED  add Medical Time: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  add Medical Time: " + message + "\n");
        }
        if (event == 147) {
            this.b.info("RED  remove Medical Time: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  remove Medical Time: " + message + "\n");
        }
        if (event == 148) {
            this.b.info("BLUE  add Medical Time: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  add Medical Time: " + message + "\n");
        }
        if (event == 149) {
            this.b.info("BLUE  remove Medical Time: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  remove Medical Time: " + message + "\n");
        }
        if (event == 150) {
            this.b.info("RED  start Medical Time: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  start Medical Time: " + message + "\n");
        }
        if (event == 151) {
            this.b.info("BLUE  start Medical Time: " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  start Medical Time: " + message + "\n");
        }
        if (event == 153) {
            this.b.info("New round " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] New round " + message + "\n");
            this.c.notifyListeners(113, "New round " + message);
            this.addRound();
        }
        if (event == 154) {
            this.b.info(message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] " + message + "\n");
            this.c.notifyListeners(113, message);
        }
        if (event == 155) {
            this.b.info(message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] " + message + "\n");
            this.removeRound();
        }
        if (event == 204) {
            this.b.info("RED  add 1 point ...");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  add 1 point ... \n");
            this.addEvent(this.g, 1, 1);
        }
        if (event == 205) {
            this.b.info("RED  add 2 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  add 2 point ... \n");
            this.addEvent(this.g, 2, 1);
        }
        if (event == 206) {
            this.b.info("RED  add 4 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  add 4 point ... \n");
            this.addEvent(this.g, 4, 1);
        }
        if (event == 207) {
            this.b.info("RED  add 2 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  add 2 point ... \n");
            this.addEvent(this.g, 2, 1);
        }
        if (event == 208) {
            this.b.info("RED  add 4 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  add 4 point ... \n");
            this.addEvent(this.g, 4, 1);
        }
        if (event == 214) {
            this.b.info("RED  remove 1 point ...");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  remove 1 point ... \n");
            this.addEvent(this.g, -1, 1);
        }
        if (event == 215) {
            this.b.info("RED  remove 2 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  remove 2 point ... \n");
            this.addEvent(this.g, -2, 1);
        }
        if (event == 216) {
            this.b.info("RED  remove 4 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  remove 4 point ... \n");
            this.addEvent(this.g, -4, 1);
        }
        if (event == 217) {
            this.b.info("RED  remove 2 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  remove 2 point ... \n");
            this.addEvent(this.g, -2, 1);
        }
        if (event == 218) {
            this.b.info("RED  remove 4 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] RED  remove 4 point ... \n");
            this.addEvent(this.g, -4, 1);
        }
        if (event == 209) {
            this.b.info("BLUE  add 1 point ...");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  add 1 point ... \n");
            this.addEvent(this.g, 1, 2);
        }
        if (event == 210) {
            this.b.info("BLUE  add 2 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  add 2 point ... \n");
            this.addEvent(this.g, 2, 2);
        }
        if (event == 211) {
            this.b.info("BLUE  add 4 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  add 4 point ... \n");
            this.addEvent(this.g, 4, 2);
        }
        if (event == 212) {
            this.b.info("BLUE  add 2 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  add 2 point ... \n");
            this.addEvent(this.g, 2, 2);
        }
        if (event == 213) {
            this.b.info("BLUE  add 4 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  add 4 point ... \n");
            this.addEvent(this.g, 4, 2);
        }
        if (event == 219) {
            this.b.info("BLUE  remove 1 point ...");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  remove 1 point ... \n");
            this.addEvent(this.g, -1, 2);
        }
        if (event == 220) {
            this.b.info("BLUE  remove 2 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  remove 2 point ... \n");
            this.addEvent(this.g, -2, 2);
        }
        if (event == 221) {
            this.b.info("BLUE  remove 4 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  remove 4 point ... \n");
            this.addEvent(this.g, -4, 2);
        }
        if (event == 222) {
            this.b.info("BLUE  remove 2 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  remove 2 point ... \n");
            this.addEvent(this.g, -2, 2);
        }
        if (event == 223) {
            this.b.info("BLUE  remove 4 points ... ");
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] BLUE  remove 4 point ... \n");
            this.addEvent(this.g, -4, 2);
        }
        if (event == 171) {
            this.b.info(message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] " + message + "\n");
        }
        if (event == 172) {
            this.b.info(message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] " + message + "\n");
        }
        if (event == 173) {
            this.b.info(message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] " + message + "\n");
        }
        if (event == 174) {
            this.b.info(message);
            this.a.append(DateUtils.getLogDateFormated() + " [INFO] " + message + "\n");
        }
        if (event == 190) {
            this.b.info(" [TIME] " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [TIME] " + message + "\n");
        }
        if (event == 191) {
            this.b.info(" [TIME] " + message);
            this.a.append(DateUtils.getLogDateFormated() + " [TIME] " + message + "\n");
        }
        this.a.setCaretPosition(this.a.getText().length());
    }

    public void appendCustomText(String text) {
        this.b.info(text);
        this.a.append(DateUtils.getLogDateFormated() + " [INFO] " + text + "\n");
        this.a.setCaretPosition(this.a.getText().length());
    }

    public void resetEvents() {
        this.e.clear();
        this.f.clear();
        this.g = 1;
    }

    public void addRound() {
        ++this.g;
        if (!this.e.containsKey(this.g)) {
            this.e.put(this.g, new ArrayList());
        }
        if (!this.f.containsKey(this.g)) {
            this.f.put(this.g, new ArrayList());
        }
    }

    public void removeRound() {
        if (this.e.containsKey(this.g)) {
            this.e.remove(this.g);
        }
        if (this.f.containsKey(this.g)) {
            this.f.remove(this.g);
        }
        --this.g;
        if (!this.e.containsKey(this.g)) {
            this.e.put(this.g, new ArrayList());
        }
        if (!this.f.containsKey(this.g)) {
            this.f.put(this.g, new ArrayList());
        }
    }

    public void addEvent(int round, int eventint, int redblue) {
        if (!this.e.containsKey(round)) {
            this.e.put(round, new ArrayList());
        }
        if (!this.f.containsKey(round)) {
            this.f.put(round, new ArrayList());
        }
        if (redblue == 1) {
            this.e.get(round).add(eventint);
        }
        if (redblue == 2) {
            this.f.get(round).add(eventint);
        }
        this.b.info(this.getAllEventsAsString());
        this.a.append(DateUtils.getLogDateFormated() + " [INFO] " + this.getAllEventsAsString() + "\n");
    }

    public String getEventsAsString(int round, int redblue) {
        int i;
        Object eventsstr = "";
        if (redblue == 1 && this.e.containsKey(round)) {
            i = 0;
            while (i < this.e.get(round).size()) {
                eventsstr = i == 0 ? (String)eventsstr + String.valueOf(this.e.get(round).get(i)) : (String)eventsstr + ", " + String.valueOf(this.e.get(round).get(i));
                ++i;
            }
        }
        if (redblue == 2 && this.f.containsKey(round)) {
            i = 0;
            while (i < this.f.get(round).size()) {
                eventsstr = i == 0 ? (String)eventsstr + String.valueOf(this.f.get(round).get(i)) : (String)eventsstr + ", " + String.valueOf(this.f.get(round).get(i));
                ++i;
            }
        }
        return eventsstr;
    }

    public String getAllEventsAsString() {
        int i;
        Object eventsstr = "";
        eventsstr = (String)eventsstr + "RED: ";
        for (int round : this.e.keySet()) {
            eventsstr = (String)eventsstr + "[" + round + "] ";
            i = 0;
            while (i < this.e.get(round).size()) {
                eventsstr = i == 0 ? (String)eventsstr + String.valueOf(this.e.get(round).get(i)) : (String)eventsstr + ", " + String.valueOf(this.e.get(round).get(i));
                ++i;
            }
        }
        Iterator<Integer> it = this.f.keySet().iterator();
        eventsstr = (String)eventsstr + " BLUE: ";
        while (it.hasNext()) {
            int round;
            round = it.next();
            eventsstr = (String)eventsstr + "[" + round + "] ";
            i = 0;
            while (i < this.f.get(round).size()) {
                eventsstr = i == 0 ? (String)eventsstr + String.valueOf(this.f.get(round).get(i)) : (String)eventsstr + ", " + String.valueOf(this.f.get(round).get(i));
                ++i;
            }
        }
        return eventsstr;
    }
}

