/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw.ogl;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.impl.hw.Drawable;
import com.sun.scenario.effect.impl.hw.RendererDelegate;
import com.sun.scenario.effect.impl.hw.Shader;
import com.sun.scenario.effect.impl.hw.Texture;
import com.sun.scenario.effect.impl.hw.ogl.OGLShader;
import com.sun.scenario.effect.impl.hw.ogl.OGLTexture;
import java.io.InputStream;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLProfile;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OGLRendererDelegate
implements RendererDelegate {
    private final boolean useExtContext;
    private GLContext extContext;

    public OGLRendererDelegate() {
        this(true);
    }

    public OGLRendererDelegate(boolean bl) {
        this.useExtContext = bl;
    }

    public Effect.AccelType getAccelType() {
        return Effect.AccelType.OPENGL;
    }

    public void setListener(RendererDelegate.Listener listener) {
    }

    public void enable() {
        if (this.useExtContext) {
            if (this.extContext == null) {
                this.extContext = GLDrawableFactory.getFactory((GLProfile)GLProfile.get((String)"GL2")).createExternalGLContext();
            }
            this.extContext.makeCurrent();
        }
    }

    public void disable() {
        if (this.useExtContext) {
            this.extContext.release();
        }
    }

    public void dispose() {
    }

    private static InputStream getStream(String string) {
        return OGLRendererDelegate.class.getResourceAsStream("glsl/" + string + ".glsl");
    }

    public Shader createShader(String string, Map<String, Integer> map, Map<String, Integer> map2) {
        return OGLShader.create(OGLRendererDelegate.getStream(string), map);
    }

    public Texture createFloatTexture(int n, int n2) {
        return OGLTexture.createFloat(n, n2);
    }

    public void updateFloatTexture(Object object, FloatMap floatMap) {
        OGLTexture oGLTexture = (OGLTexture)object;
        oGLTexture.update(floatMap);
    }

    private GL2 getCurrentGL() {
        return GLU.getCurrentGL().getGL2();
    }

    public void drawQuad(Drawable drawable, float f, float f2, float f3, float f4) {
        GL2 gL2 = this.getCurrentGL();
        gL2.glBegin(7);
        gL2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gL2.glVertex2f(f, f2);
        gL2.glVertex2f(f3, f2);
        gL2.glVertex2f(f3, f4);
        gL2.glVertex2f(f, f4);
        gL2.glEnd();
    }

    public void drawTexture(Drawable drawable, Texture texture, boolean bl, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        GL2 gL2 = this.getCurrentGL();
        int n = 3553;
        int n2 = (int)texture.getNativeSourceHandle();
        gL2.glEnable(n);
        gL2.glBindTexture(n, n2);
        int n3 = bl ? 9729 : 9728;
        gL2.glTexParameteri(n, 10242, 33069);
        gL2.glTexParameteri(n, 10243, 33069);
        gL2.glTexParameteri(n, 10241, n3);
        gL2.glTexParameteri(n, 10240, n3);
        gL2.glBegin(7);
        gL2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gL2.glTexCoord2f(f5, f6);
        gL2.glVertex2f(f, f2);
        gL2.glTexCoord2f(f7, f6);
        gL2.glVertex2f(f3, f2);
        gL2.glTexCoord2f(f7, f8);
        gL2.glVertex2f(f3, f4);
        gL2.glTexCoord2f(f5, f8);
        gL2.glVertex2f(f, f4);
        gL2.glEnd();
        gL2.glBindTexture(n, 0);
        gL2.glDisable(n);
    }

    public void drawTexture(Drawable drawable, Texture texture, boolean bl, Texture texture2, boolean bl2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        GL2 gL2 = this.getCurrentGL();
        int n = 3553;
        int n2 = (int)texture.getNativeSourceHandle();
        int n3 = 3553;
        int n4 = (int)texture2.getNativeSourceHandle();
        gL2.glActiveTexture(33984);
        gL2.glEnable(n);
        gL2.glBindTexture(n, n2);
        int n5 = bl ? 9729 : 9728;
        gL2.glTexParameteri(n, 10242, 33069);
        gL2.glTexParameteri(n, 10243, 33069);
        gL2.glTexParameteri(n, 10241, n5);
        gL2.glTexParameteri(n, 10240, n5);
        gL2.glActiveTexture(33985);
        gL2.glEnable(n3);
        gL2.glBindTexture(n3, n4);
        int n6 = bl2 ? 9729 : 9728;
        gL2.glTexParameteri(n3, 10242, 33069);
        gL2.glTexParameteri(n3, 10243, 33069);
        gL2.glTexParameteri(n3, 10241, n6);
        gL2.glTexParameteri(n3, 10240, n6);
        gL2.glBegin(7);
        gL2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gL2.glMultiTexCoord2f(33984, f5, f6);
        gL2.glMultiTexCoord2f(33985, f9, f10);
        gL2.glVertex2f(f, f2);
        gL2.glMultiTexCoord2f(33984, f7, f6);
        gL2.glMultiTexCoord2f(33985, f11, f10);
        gL2.glVertex2f(f3, f2);
        gL2.glMultiTexCoord2f(33984, f7, f8);
        gL2.glMultiTexCoord2f(33985, f11, f12);
        gL2.glVertex2f(f3, f4);
        gL2.glMultiTexCoord2f(33984, f5, f8);
        gL2.glMultiTexCoord2f(33985, f9, f12);
        gL2.glVertex2f(f, f4);
        gL2.glEnd();
        gL2.glActiveTexture(33985);
        gL2.glBindTexture(n3, 0);
        gL2.glDisable(n3);
        gL2.glActiveTexture(33984);
        gL2.glBindTexture(n, 0);
        gL2.glDisable(n);
    }
}

