/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw.ogl;

import com.sun.scenario.effect.impl.hw.Shader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OGLShader
implements Shader {
    private int id;
    private boolean valid;

    public OGLShader(String string, Map<String, Integer> map) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        this.id = OGLShader.createProgram(gL2, null, string);
        boolean bl = this.valid = this.id != 0;
        if (map != null) {
            this.enable();
            for (String string2 : map.keySet()) {
                this.setConstant(string2, map.get(string2));
            }
            this.disable();
        }
    }

    public static OGLShader create(InputStream inputStream, Map<String, Integer> map) {
        return new OGLShader(OGLShader.readStream(inputStream), map);
    }

    private static GL2 getCurrentGL() {
        return GLU.getCurrentGL().getGL2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readStream(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = bufferedReader.read(cArray)) > -1) {
                stringBuffer.append(String.valueOf(cArray, 0, n));
            }
        }
        catch (IOException iOException) {
            System.err.println("Error reading stream");
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println("Error closing reader");
            }
        }
        return stringBuffer.toString();
    }

    private static int createProgram(GL2 gL2, String string, String string2) throws GLException {
        if (string == null && string2 == null) {
            throw new GLException("Either vertexShaderSource or fragmentShaderSource must be specified");
        }
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (string != null && (n = OGLShader.compileShader(gL2, string, true)) == 0) {
            return 0;
        }
        if (string2 != null && (n2 = OGLShader.compileShader(gL2, string2, false)) == 0) {
            if (n != 0) {
                gL2.glDeleteObjectARB(n);
            }
            return 0;
        }
        int n3 = gL2.glCreateProgramObjectARB();
        if (n != 0) {
            gL2.glAttachObjectARB(n3, n);
            gL2.glDeleteObjectARB(n);
        }
        if (n2 != 0) {
            gL2.glAttachObjectARB(n3, n2);
            gL2.glDeleteObjectARB(n2);
        }
        gL2.glLinkProgramARB(n3);
        gL2.glGetObjectParameterivARB(n3, 35714, nArray, 0);
        gL2.glGetObjectParameterivARB(n3, 35716, nArray2, 0);
        if (nArray2[0] > 1) {
            int n4 = nArray2[0];
            byte[] byArray = new byte[n4];
            gL2.glGetInfoLogARB(n3, n4, null, 0, byArray, 0);
            System.err.println("Linker message: " + new String(byArray));
        }
        if (nArray[0] == 0) {
            gL2.glDeleteObjectARB(n3);
            return 0;
        }
        return n3;
    }

    private static int compileShader(GL2 gL2, String string, boolean bl) throws GLException {
        int n = bl ? 35633 : 35632;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = gL2.glCreateShaderObjectARB(n);
        gL2.glShaderSourceARB(n2, 1, new String[]{string}, new int[]{-1}, 0);
        gL2.glCompileShaderARB(n2);
        gL2.glGetObjectParameterivARB(n2, 35713, nArray, 0);
        gL2.glGetObjectParameterivARB(n2, 35716, nArray2, 0);
        if (nArray2[0] > 1) {
            int n3 = nArray2[0];
            byte[] byArray = new byte[n3];
            gL2.glGetInfoLogARB(n2, n3, null, 0, byArray, 0);
            System.err.println(string);
            System.err.println((bl ? "Vertex" : "Fragment") + " compile message: " + new String(byArray));
        }
        if (nArray[0] == 0) {
            gL2.glDeleteObjectARB(n2);
            return 0;
        }
        return n2;
    }

    public int getProgramObject() {
        return this.id;
    }

    public void enable() throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        gL2.glUseProgramObjectARB(this.id);
    }

    public void disable() throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        gL2.glUseProgramObjectARB(0);
    }

    public void dispose() throws GLException {
        this.valid = false;
        GL2 gL2 = OGLShader.getCurrentGL();
        gL2.glDeleteObjectARB(this.id);
        this.id = 0;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setConstant(String string, int n) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n2 = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform1iARB(n2, n);
    }

    public void setConstant(String string, int n, int n2) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n3 = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform2iARB(n3, n, n2);
    }

    public void setConstant(String string, int n, int n2, int n3) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n4 = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform3iARB(n4, n, n2, n3);
    }

    public void setConstant(String string, int n, int n2, int n3, int n4) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n5 = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform4iARB(n5, n, n2, n3, n4);
    }

    public void setConstant(String string, float f) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform1fARB(n, f);
    }

    public void setConstant(String string, float f, float f2) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform2fARB(n, f, f2);
    }

    public void setConstant(String string, float f, float f2, float f3) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform3fARB(n, f, f2, f3);
    }

    public void setConstant(String string, float f, float f2, float f3, float f4) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform4fARB(n, f, f2, f3, f4);
    }

    public void setConstants(String string, IntBuffer intBuffer, int n, int n2) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n3 = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform4ivARB(n3, n2, intBuffer);
    }

    public void setConstants(String string, FloatBuffer floatBuffer, int n, int n2) throws GLException {
        GL2 gL2 = OGLShader.getCurrentGL();
        int n3 = gL2.glGetUniformLocationARB(this.id, string);
        gL2.glUniform4fvARB(n3, n2, floatBuffer);
    }
}

