/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;

public final class CalendarParsedResult
extends ParsedResult {
    private final String summary;
    private final String start;
    private final String end;
    private final String location;
    private final String attendee;
    private final String title;

    public CalendarParsedResult(String summary, String start, String end, String location, String attendee, String title) {
        super(ParsedResultType.CALENDAR);
        if (start == null) {
            throw new IllegalArgumentException();
        }
        CalendarParsedResult.validateDate(start);
        CalendarParsedResult.validateDate(end);
        this.summary = summary;
        this.start = start;
        this.end = end;
        this.location = location;
        this.attendee = attendee;
        this.title = title;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAttendee() {
        return this.attendee;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDisplayResult() {
        StringBuffer result = new StringBuffer(100);
        CalendarParsedResult.maybeAppend(this.summary, result);
        CalendarParsedResult.maybeAppend(this.start, result);
        CalendarParsedResult.maybeAppend(this.end, result);
        CalendarParsedResult.maybeAppend(this.location, result);
        CalendarParsedResult.maybeAppend(this.attendee, result);
        CalendarParsedResult.maybeAppend(this.title, result);
        return result.toString();
    }

    private static void validateDate(String date) {
        if (date != null) {
            int i;
            int length = date.length();
            if (length != 8 && length != 15 && length != 16) {
                throw new IllegalArgumentException();
            }
            for (i = 0; i < 8; ++i) {
                if (Character.isDigit(date.charAt(i))) continue;
                throw new IllegalArgumentException();
            }
            if (length > 8) {
                if (date.charAt(8) != 'T') {
                    throw new IllegalArgumentException();
                }
                for (i = 9; i < 15; ++i) {
                    if (Character.isDigit(date.charAt(i))) continue;
                    throw new IllegalArgumentException();
                }
                if (length == 16 && date.charAt(15) != 'Z') {
                    throw new IllegalArgumentException();
                }
            }
        }
    }
}

