/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.util.Vector;

final class VCardResultParser
extends ResultParser {
    private VCardResultParser() {
    }

    public static AddressBookParsedResult parse(Result result) {
        String rawText = result.getText();
        if (rawText == null || !rawText.startsWith("BEGIN:VCARD")) {
            return null;
        }
        String[] names = VCardResultParser.matchVCardPrefixedField("FN", rawText, true);
        if (names == null) {
            names = VCardResultParser.matchVCardPrefixedField("N", rawText, true);
            VCardResultParser.formatNames(names);
        }
        String[] phoneNumbers = VCardResultParser.matchVCardPrefixedField("TEL", rawText, true);
        String[] emails = VCardResultParser.matchVCardPrefixedField("EMAIL", rawText, true);
        String note = VCardResultParser.matchSingleVCardPrefixedField("NOTE", rawText, false);
        String[] addresses = VCardResultParser.matchVCardPrefixedField("ADR", rawText, true);
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                addresses[i] = VCardResultParser.formatAddress(addresses[i]);
            }
        }
        String org = VCardResultParser.matchSingleVCardPrefixedField("ORG", rawText, true);
        String birthday = VCardResultParser.matchSingleVCardPrefixedField("BDAY", rawText, true);
        if (!VCardResultParser.isLikeVCardDate(birthday)) {
            birthday = null;
        }
        String title = VCardResultParser.matchSingleVCardPrefixedField("TITLE", rawText, true);
        String url = VCardResultParser.matchSingleVCardPrefixedField("URL", rawText, true);
        return new AddressBookParsedResult(names, null, phoneNumbers, emails, note, addresses, org, birthday, title, url);
    }

    private static String[] matchVCardPrefixedField(String prefix, String rawText, boolean trim) {
        Vector<String> matches = null;
        int i = 0;
        int max = rawText.length();
        while (i < max && (i = rawText.indexOf(prefix, i)) >= 0) {
            if (i > 0 && rawText.charAt(i - 1) != '\n') {
                ++i;
                continue;
            }
            if (rawText.charAt(i += prefix.length()) != ':' && rawText.charAt(i) != ';') continue;
            while (rawText.charAt(i) != ':') {
                ++i;
            }
            int start = ++i;
            if ((i = rawText.indexOf(10, i)) < 0) {
                i = max;
                continue;
            }
            if (i > start) {
                if (matches == null) {
                    matches = new Vector<String>(3);
                }
                String element = rawText.substring(start, i);
                if (trim) {
                    element = element.trim();
                }
                matches.addElement(element);
                ++i;
                continue;
            }
            ++i;
        }
        if (matches == null || matches.isEmpty()) {
            return null;
        }
        return VCardResultParser.toStringArray(matches);
    }

    static String matchSingleVCardPrefixedField(String prefix, String rawText, boolean trim) {
        String[] values = VCardResultParser.matchVCardPrefixedField(prefix, rawText, trim);
        return values == null ? null : values[0];
    }

    private static boolean isLikeVCardDate(String value) {
        if (value == null) {
            return true;
        }
        if (VCardResultParser.isStringOfDigits(value, 8)) {
            return true;
        }
        return value.length() == 10 && value.charAt(4) == '-' && value.charAt(7) == '-' && VCardResultParser.isSubstringOfDigits(value, 0, 4) && VCardResultParser.isSubstringOfDigits(value, 5, 2) && VCardResultParser.isSubstringOfDigits(value, 8, 2);
    }

    private static String formatAddress(String address) {
        if (address == null) {
            return null;
        }
        int length = address.length();
        StringBuffer newAddress = new StringBuffer(length);
        for (int j = 0; j < length; ++j) {
            char c = address.charAt(j);
            if (c == ';') {
                newAddress.append(' ');
                continue;
            }
            newAddress.append(c);
        }
        return newAddress.toString().trim();
    }

    private static void formatNames(String[] names) {
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                int end;
                String name = names[i];
                String[] components = new String[5];
                int start = 0;
                int componentIndex = 0;
                while ((end = name.indexOf(59, start)) > 0) {
                    components[componentIndex] = name.substring(start, end);
                    ++componentIndex;
                    start = end + 1;
                }
                components[componentIndex] = name.substring(start);
                StringBuffer newName = new StringBuffer(100);
                VCardResultParser.maybeAppendComponent(components, 3, newName);
                VCardResultParser.maybeAppendComponent(components, 1, newName);
                VCardResultParser.maybeAppendComponent(components, 2, newName);
                VCardResultParser.maybeAppendComponent(components, 0, newName);
                VCardResultParser.maybeAppendComponent(components, 4, newName);
                names[i] = newName.toString().trim();
            }
        }
    }

    private static void maybeAppendComponent(String[] components, int i, StringBuffer newName) {
        if (components[i] != null) {
            newName.append(' ');
            newName.append(components[i]);
        }
    }
}

