/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.actions.AbstractInstallOrUninstallAction;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.SystemLoaded;
import com.install4j.runtime.beans.actions.files.ArchiveFileOperationRoot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SystemInstallOrUninstallAction
extends AbstractInstallOrUninstallAction
implements SystemLoaded {
    private List<InstallAction> rollbackActions = new ArrayList<InstallAction>();
    private Map<String, Object> variableBackup = new HashMap<String, Object>();
    private File overriddenTargetDir;
    private boolean suppressRollback;

    public abstract boolean execute(Context var1) throws UserCanceledException;

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        this.initVariables(context);
        return this.execute(context);
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        this.initVariables(context);
        return this.execute(context);
    }

    private void initVariables(Context context) {
        this.overriddenTargetDir = (File)context.getVariable("sys.overriddenTargetDir");
        this.suppressRollback = context.getBooleanVariable("sys.actionSuppressRollback");
    }

    protected File resolveRelativeFile(File file, Context context) {
        return this.resolveRelativeFile(file, null, context);
    }

    protected File resolveRelativeFile(File file, ArchiveFileOperationRoot filesRoot, Context context) {
        if (!(filesRoot != null && filesRoot != ArchiveFileOperationRoot.ARCHIVE || this.overriddenTargetDir == null || file == null || file.isAbsolute())) {
            return new File(this.overriddenTargetDir, file.getPath());
        }
        return context.getDestinationFile(file);
    }

    protected boolean isInOverriddenTargetDir(File file) {
        try {
            return this.overriddenTargetDir != null && file != null && file.getCanonicalPath().startsWith(this.overriddenTargetDir.getPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    protected boolean isSuppressRollback() {
        return this.suppressRollback;
    }

    protected void addRollbackAction(InstallAction action) {
        this.rollbackActions.add(action);
    }

    protected void addRollbackActions(Collection<InstallAction> collection) {
        this.rollbackActions.addAll(collection);
    }

    @Override
    public void rollback(InstallerContext context) {
        for (int i = this.rollbackActions.size() - 1; i >= 0; --i) {
            InstallAction action = this.rollbackActions.get(i);
            action.rollback(context);
        }
    }

    protected void overrideVariable(String name, Object value, Context context) {
        this.variableBackup.put(name, context.getVariable(name));
        context.setVariable(name, value);
    }

    protected void restoreVariables(Context context) {
        for (Map.Entry<String, Object> entry : this.variableBackup.entrySet()) {
            context.setVariable(entry.getKey(), entry.getValue());
        }
        this.variableBackup.clear();
    }
}

