/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.ApplicationRegistry;
import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.LauncherType;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.InstallerScreen;
import com.install4j.api.screens.Screen;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.AutoUninstallHandler;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.beans.actions.desktop.AbstractAssociationAction;
import com.install4j.runtime.beans.actions.misc.VariableSelectionMode;
import com.install4j.runtime.beans.actions.services.InstallServiceAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.IdWrapperInstallerContext;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Install4jClassLoader;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.Unpacker;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.installer.platform.macos.MacFileSystem;
import com.install4j.runtime.installer.platform.unix.LegacyUnixFileSystem;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.util.DirectoryUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InstallerContextImpl
extends ContextImpl
implements InstallerContext,
Serializable {
    private static final String REGVAL_REBOOT_CHECK_FILE = "RebootCheckFile";
    private List<AutoUninstallAction> autoUninstallActions = new ArrayList<AutoUninstallAction>();
    private static final String LOG_FILE_NAME = "installation.log";
    public static final String RESPONSE_FILE_NAME = "response.varfile";
    private Map<String, InstallerContext> idNamespaceToContext = new HashMap<String, InstallerContext>();
    private boolean updateInstallation;
    private File additionalUserJarsDir;
    private boolean keepAdditionalUserJars;
    private static List<Runnable> afterFinishActions = new ArrayList<Runnable>();

    public InstallerContextImpl(ScreenExecutor screenExecutor) {
        super(screenExecutor);
        InstallerVariables.registerVariableProvider("sys.installationDir", new InstallerVariables.VariableProvider(){

            @Override
            public Object getVariable() {
                return InstallerContextImpl.this.getInstallationDirectory().getPath();
            }

            @Override
            public void setVariable(Object value) {
                if (value instanceof String) {
                    InstallerContextImpl.this.setInstallationDirectory(new File((String)value), false);
                }
            }
        });
        InstallerVariables.registerResponseFileVariable("sys.installationDir");
    }

    public static void registerAfterFinishAction(Runnable runnable) {
        afterFinishActions.add(runnable);
    }

    @Override
    public File getAdditionalUserJarsDir() {
        return this.additionalUserJarsDir;
    }

    @Override
    public File getInstallerFile() {
        String fileName = System.getProperty("exe4j.moduleName");
        if (fileName == null) {
            return null;
        }
        return new File(fileName);
    }

    @Override
    public String getMediaName() {
        return InstallerConfig.getCurrentInstance().getMediaName();
    }

    @Override
    public void applyToScreen(Screen screen, ScreenBeanConfig config) {
        if (screen instanceof InstallerScreen) {
            ((InstallerScreen)screen).setInstallerContext(this.getIdWrapperInstallerContext(config));
        }
    }

    @Override
    public Context getIdWrapperContext(AbstractBeanConfig config) {
        return this.getIdWrapperInstallerContext(config);
    }

    private InstallerContext getIdWrapperInstallerContext(AbstractBeanConfig config) {
        String idNamespace = config.getIdNamespace();
        if (idNamespace.length() == 0) {
            return this;
        }
        InstallerContext wrapperContext = this.idNamespaceToContext.get(idNamespace);
        if (wrapperContext == null) {
            wrapperContext = new IdWrapperInstallerContext(this, idNamespace);
            this.idNamespaceToContext.put(idNamespace, wrapperContext);
        }
        return wrapperContext;
    }

    @Override
    public boolean installFile(File sourceFile, File destFile) throws UserCanceledException {
        return FileInstaller.getInstance().install(sourceFile, destFile);
    }

    @Override
    public boolean installFile(File sourceFile, File destFile, FileOptions options) throws UserCanceledException {
        return FileInstaller.getInstance().install(sourceFile, destFile, options);
    }

    @Override
    public void registerUninstallFile(File file) {
        FileInstaller.getInstance().registerUninstallFile(file);
    }

    @Override
    public boolean installFile(File sourceFile, File destFile, FileOptions options, ProgressInterface progressInterface, int fromPercent, int toPercent) throws UserCanceledException {
        if (progressInterface != null) {
            progressInterface = new ProgressAdapter(progressInterface, fromPercent, toPercent);
        }
        return FileInstaller.getInstance().install(sourceFile, destFile, options, progressInterface);
    }

    @Override
    public void installDirectory(File directory, UninstallMode uninstallMode) {
        FileInstaller.getInstance().createDirectory(directory, uninstallMode);
    }

    @Override
    public boolean performActionInt(ActionBeanConfig config) throws UserCanceledException {
        InstallerContext currentContext = this.getIdWrapperInstallerContext(config);
        boolean ok = InstallerContextImpl.performActionIntStatic(config, currentContext);
        Action action = config.getOrInstantiateAction(false);
        if (ok && action instanceof AutoUninstallAction) {
            this.autoUninstallActions.add((AutoUninstallAction)action);
        }
        return ok;
    }

    @Override
    public void rollbackActionInt(ActionBeanConfig config) {
        Action action = config.getOrInstantiateAction(false);
        InstallerContext currentContext = this.getIdWrapperInstallerContext(config);
        InstallerContextImpl.rollbackActionIntStatic(config, (InstallAction)action, currentContext);
    }

    private static void rollbackActionIntStatic(ActionBeanConfig config, final InstallAction action, InstallerContext currentContext) {
        ContextImpl.setCurrentContext(currentContext);
        try {
            HelperCommunication.getInstance().executeAction(config.getExecutionContext(), new RunAction(){

                @Override
                protected void run(Context context) {
                    action.rollback((InstallerContext)context);
                }
            });
        }
        finally {
            ContextImpl.setCurrentContext(null);
        }
    }

    @Override
    public String getLanguageId() {
        if (super.getLanguageId() == null) {
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            List<LanguageConfig> languages = config.getLanguages();
            if (languages.size() == 1) {
                this.setLanguageId(languages.get(0).getId());
            } else if (config.isSkipLanguageSelection() || this.isUnattended() || config.isArchive()) {
                String systemLanguageId = InstallerUtil.getSupportedSystemLanguageId();
                if (systemLanguageId != null) {
                    this.setLanguageId(systemLanguageId);
                } else if (this.isUnattended() || config.isArchive()) {
                    this.setLanguageId(InstallerConfig.getCurrentInstance().getLanguages().get(0).getId());
                }
            }
        }
        return super.getLanguageId();
    }

    @Override
    public boolean checkStart() {
        boolean start;
        if (Util.isWindows() && InstallerConfig.isInstaller()) {
            if (this.checkReboot(RegistryRoot.HKEY_CURRENT_USER)) {
                return false;
            }
            if (this.checkReboot(RegistryRoot.HKEY_LOCAL_MACHINE)) {
                return false;
            }
        }
        if ((start = super.checkStart()) && (Util.isMacosInstaller() || Util.isUnixInstaller())) {
            this.unpackAdditionalUserFiles();
        }
        return start;
    }

    /*
     * Unable to fully structure code
     */
    private void unpackAdditionalUserFiles() {
        userJarDirName = System.getProperty("install4j.addUserDir");
        if (userJarDirName != null) {
            this.additionalUserJarsDir = new File(userJarDirName);
        } else {
            files = InstallerUtil.getInstallerFile("user").listFiles();
            if (files != null) {
                hasPackedFile = false;
                for (File file : files) {
                    if (!file.getName().endsWith(".pack")) continue;
                    hasPackedFile = true;
                    break;
                }
                if (hasPackedFile) {
                    try {
                        tempFile = File.createTempFile("i4jau", "");
                        this.additionalUserJarsDir = new File(tempFile.getAbsolutePath() + ".dir");
                        while (!this.additionalUserJarsDir.mkdir()) {
                            tempFile.deleteOnExit();
                            tempFile = File.createTempFile("i4jau", "");
                            this.additionalUserJarsDir = new File(tempFile.getAbsolutePath() + ".dir");
                        }
                        tempFile.delete();
                        for (File file : files) {
                            fileName = file.getName();
                            if (fileName.endsWith(".pack")) {
                                destFile = new File(this.additionalUserJarsDir, fileName.substring(0, fileName.length() - ".pack".length()));
                                try {
                                    if (Unpacker.unpack(file, destFile, null)) ** GOTO lbl38
                                    FileUtil.copyFile(file, destFile);
                                }
                                catch (IOException e) {
                                    System.err.println("While unpacking " + fileName);
                                    throw e;
                                }
                            } else {
                                destFile = new File(this.additionalUserJarsDir, fileName);
                                FileUtil.copyFile(file, destFile);
                            }
lbl38:
                            // 3 sources

                            if (!destFile.getName().endsWith(".jar") && !destFile.getName().endsWith(".zip")) continue;
                            Install4jClassLoader.addClassPath(destFile);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    for (File file : files) {
                        if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                        Install4jClassLoader.addClassPath(file);
                    }
                }
            }
        }
    }

    private boolean checkReboot(RegistryRoot root) {
        String checkFile = (String)WinRegistry.getValue(root, "SOFTWARE\\ej-technologies\\install4j\\", REGVAL_REBOOT_CHECK_FILE);
        if (checkFile != null) {
            if (new File(checkFile).exists()) {
                String message = Messages.format(Messages.getString(".PreviousInstallNotCompleted"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
                Util.showMessage(message, 2);
                return true;
            }
            WinRegistry.deleteValue(root, "SOFTWARE\\ej-technologies\\install4j\\", REGVAL_REBOOT_CHECK_FILE);
        }
        return false;
    }

    @Override
    public void exit(int exitCode) {
        if (this.additionalUserJarsDir != null && !this.keepAdditionalUserJars) {
            FileUtil.deleteDirectory(this.additionalUserJarsDir);
        }
        if (InstallerVariables.getBooleanVariable("sys.automaticUpdate")) {
            AutomaticUpdate.checkRegularExit(exitCode == 0, cancelling);
        }
        super.exit(exitCode);
    }

    @Override
    public void finish(int exitCode) {
        block12: {
            try {
                boolean singleBundleArchive;
                InstallerConfig config = InstallerConfig.getCurrentInstance();
                if (!Util.isWindows() && !Util.isMacOS()) {
                    try {
                        AbstractAssociationAction.logUnhandledUnixAssociations();
                    }
                    catch (Throwable t) {
                        Logger.getInstance().log(t);
                    }
                }
                if (InstallerConfig.isInstaller()) {
                    String singleBundleName = null;
                    if (Util.isMacosInstaller() && config.getMacSpecificConfig().isSingleBundle()) {
                        singleBundleName = config.getMacSpecificConfig().getSingleBundleName();
                    }
                    InstallRegistry.registerApplication(config.getApplicationId(), this.getInstallationDirectory(), singleBundleName);
                    MsiHelper.writeMsiUninstaller(this);
                }
                boolean bl = singleBundleArchive = Util.isMacosInstaller() && config.getMacSpecificConfig().isSingleBundle() && config.isArchive();
                if (!singleBundleArchive) {
                    String logFileDestination;
                    File runtimeDirectory = this.getRuntimeDirectory();
                    String suffix = "";
                    if (InstallerConfig.getCurrentInstance().isAddOnInstaller()) {
                        suffix = "." + InstallerConfig.getCurrentInstance().getProjectCrc();
                    }
                    File logFile = (logFileDestination = System.getProperty("install4j.logFileDestination")) != null ? new File(logFileDestination) : new File(runtimeDirectory, LOG_FILE_NAME + suffix);
                    File responseFile = new File(runtimeDirectory, RESPONSE_FILE_NAME + suffix);
                    byte[] responseFileContent = null;
                    if (runtimeDirectory.exists() && !Boolean.getBoolean("install4j.dontStoreInstallationInfo")) {
                        InstallationProperties installationProperties = null;
                        if (InstallerConfig.isInstaller() && !Boolean.getBoolean("install4j.dontStoreInstallationLog")) {
                            installationProperties = this.finishInstallationProperties();
                            FileInstaller.getInstance().registerUninstallFile(logFile);
                            Logger.getImpl().setFinalLogFile(logFile);
                            responseFileContent = InstallerVariables.getResponseFileContent(VariableSelectionMode.EXCLUDE, null);
                            FileInstaller.getInstance().registerUninstallFile(responseFile);
                        }
                        Collections.reverse(this.autoUninstallActions);
                        byte[] autoUninstallBytes = AutoUninstallHandler.getPropertyFileBytes(this.autoUninstallActions);
                        InstallerContextImpl.writeFinalRuntimeContent(autoUninstallBytes, runtimeDirectory, responseFile, responseFileContent, installationProperties);
                        FileInstaller.getInstance().setLogDir(this.getDestinationFile(".install4j"));
                        FileInstaller.getInstance().writeLog();
                    }
                }
                InstallerContextImpl.cleanupSystemPrefsInTempDir();
            }
            catch (UserCanceledException config) {
            }
            catch (IOException e) {
                if (!InstallerConfig.isInstaller() || !InstallFilesAction.hasRun()) break block12;
                this.handleCriticalException(e);
            }
        }
        super.finish(exitCode);
    }

    private static void cleanupSystemPrefsInTempDir() {
        try {
            if (InstallerConfig.isInstaller() && !Util.isWindows() && !Util.isMacOS()) {
                File currentDir;
                LaunchHelper.syncPreferences();
                final File systemRootDir = new File(System.getProperty("java.home"), ".systemPrefs");
                if (systemRootDir.isDirectory() && (currentDir = new File(System.getProperty("user.dir"))).getName().endsWith(".dir") && systemRootDir.getCanonicalPath().startsWith(currentDir.getCanonicalPath())) {
                    Logger.getInstance().info(null, "cleaning up system prefs in " + systemRootDir.getCanonicalPath());
                    HelperCommunication.getInstance().executeActionChecked(ExecutionContext.MAXIMUM, new RunAction(){

                        @Override
                        protected void run(Context context) throws Exception {
                            DirectoryUtil.deleteDirectory(systemRootDir);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
        }
    }

    @Override
    public void initWithVariables() {
        super.initWithVariables();
        this.initUpdateInstallation();
    }

    private static void writeFinalRuntimeContent(final byte[] autoUninstallBytes, final File runtimeDirectory, final File responseFile, final byte[] responseFileContent, final InstallationProperties installationProperties) throws IOException, UserCanceledException {
        final String accessMode = System.getProperty("install4j.runtimeAccessMode");
        HelperCommunication.getInstance().executeActionChecked(ContentInstaller.getExecutionContext(), new RunAction(){

            @Override
            protected void run(Context context) throws IOException {
                if (installationProperties != null) {
                    installationProperties.store(runtimeDirectory);
                }
                AutoUninstallHandler.writeFile(autoUninstallBytes, runtimeDirectory);
                if (responseFileContent != null && responseFile != null) {
                    FileOutputStream out = new FileOutputStream(responseFile);
                    out.write(responseFileContent);
                    out.close();
                }
                if (accessMode != null && !Util.isWindows()) {
                    try {
                        InstallerContextImpl.setPosixFilePermissionsRecursive(runtimeDirectory, accessMode);
                    }
                    catch (Exception e) {
                        Logger.getInstance().log(null, "set permissions: " + e, false);
                    }
                }
                if (Util.isMacosInstaller() && InstallerConfig.getCurrentInstance().getMacSpecificConfig().isSingleBundle()) {
                    Util.logInfo(null, "Completing application bundle");
                    InstallerConfig config = InstallerConfig.getCurrentInstance();
                    File bundleDir = new File(context.getInstallationDirectory(), config.getMacSpecificConfig().getSingleBundleName());
                    File infoPlistTempFile = new File(bundleDir, "Contents/info_plist_temp");
                    if (infoPlistTempFile.exists()) {
                        File targetFile = new File(infoPlistTempFile.getParentFile(), "Info.plist");
                        if (!infoPlistTempFile.renameTo(targetFile)) {
                            Util.logInfo(null, "Could not rename temporary file " + infoPlistTempFile + " to " + targetFile + "exists: " + targetFile.exists() + ")");
                        }
                        if (infoPlistTempFile.exists()) {
                            Util.logError(null, "Temporary file " + infoPlistTempFile + " still exists");
                        } else if (!targetFile.exists()) {
                            Util.logError(null, "Info.plist file " + targetFile + " does not exist");
                        } else {
                            Util.logError(null, "Deleted temporary Info.plist file " + infoPlistTempFile);
                            Util.logError(null, "Created Info.plist file " + targetFile);
                            Util.logInfo(null, "Application bundle has been successfully completed");
                        }
                        MacFileSystem.notifyBundleChange(bundleDir);
                    } else {
                        Util.logInfo(null, "Temporary file " + infoPlistTempFile + " does not exist");
                    }
                }
                for (Runnable runnable : afterFinishActions) {
                    runnable.run();
                }
            }
        });
    }

    private static void setPosixFilePermissionsRecursive(File dir, String mode) throws IOException {
        if (mode != null && mode.length() > 0) {
            if (Character.isDigit(mode.charAt(0))) {
                mode = LegacyUnixFileSystem.toJavaTypeMode(mode);
            }
            final Set<PosixFilePermission> posixFilePermissions = PosixFilePermissions.fromString(mode);
            Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.setPosixFilePermissions(file, posixFilePermissions);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    Files.setPosixFilePermissions(dir, posixFilePermissions);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private InstallationProperties finishInstallationProperties() throws IOException {
        InstallationProperties installationProperties = this.getInstallationProperties();
        installationProperties.setLanguageId(this.getLanguageId());
        if (MsiHelper.isStartedFromMsi()) {
            installationProperties.setMsiAllUsers(MsiHelper.isMsiAllUsers(this));
        }
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        ArrayList<String> launchers = new ArrayList<String>(config.getFileOptionsConfig().getLaunchers());
        ArrayList<File> serviceFiles = new ArrayList<File>();
        for (LauncherSetup launcherSetup : this.getLaunchers()) {
            if (launcherSetup.getType() != LauncherType.SERVICE) continue;
            serviceFiles.add(this.getDestinationFile(launcherSetup.getRelativeFileName()));
        }
        for (InstallServiceAction.Info info : InstallServiceAction.getInstalledServices()) {
            installationProperties.addStringToSet("serviceName", info.getServiceName());
        }
        for (String fileName : launchers) {
            File destinationFile = this.getDestinationFile(fileName);
            if (serviceFiles.contains(destinationFile)) continue;
            installationProperties.addFileToSet("launcher", destinationFile);
        }
        return installationProperties;
    }

    @Override
    public void setInstallationDirectory(File installationDirectory) {
        this.setInstallationDirectory(installationDirectory, true);
    }

    @Override
    public boolean isUpdateInstallation() {
        return this.updateInstallation;
    }

    private void initUpdateInstallation() {
        this.updateInstallation = ApplicationRegistry.isUpdateDirectory(this.getInstallationDirectory());
    }

    public void setInstallationDirectory(File installationDirectory, boolean fireChangeEvent) {
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        File oldInstallationDirectory = this.getInstallationDirectory();
        config.setInstallationDirectory(installationDirectory);
        if (!Objects.equals(oldInstallationDirectory, this.getInstallationDirectory())) {
            this.initUpdateInstallation();
            if (fireChangeEvent) {
                this.variableChanged("sys.installationDir");
            }
        }
    }

    @Override
    public File getExternalFile(ExternalFile externalFile, boolean installedLocation) {
        if (installedLocation || InstallerContextImpl.isDistributionExternal(externalFile) || !InstallerConfig.isInstaller()) {
            return super.getExternalFile(externalFile, installedLocation);
        }
        if (externalFile == null || externalFile.getPath().trim().length() == 0) {
            return null;
        }
        return InstallerUtil.getAbsoluteFile(externalFile);
    }

    @Override
    protected String getRebootMessage() {
        return Messages.getString(".FinishedRestartMessage");
    }

    public void setKeepAdditionalUserJars(boolean keepAdditionalUserJars) {
        this.keepAdditionalUserJars = keepAdditionalUserJars;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ContextStandin();
    }

    private static class ContextStandin
    implements Serializable {
        private ContextStandin() {
        }

        private Object readResolve() throws ObjectStreamException {
            return ContextImpl.getCurrentContext();
        }
    }
}

