/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublishRestUtil {
    private static final Log logger = LogFactory.getLog(PublishRestUtil.class);
    public static final String REPO_FILES_IMPORT = "api/repo/publish/file";
    private final String baseUrl;
    private final String username;
    private final String password;
    private Client client = null;

    public PublishRestUtil(String baseUrl, String username, String password) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + '/';
        this.username = username;
        this.password = password;
        this.initRestService();
    }

    private void initRestService() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(MultiPartWriter.class);
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        this.client = Client.create((ClientConfig)clientConfig);
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
    }

    public int publishFile(String filePath, byte[] data, boolean overwriteIfExists) throws IOException {
        if (filePath == null || data == null || data.length == 0) {
            throw new IOException("missing file path and/or data");
        }
        String path = filePath;
        String fileName = null;
        int fileNameIdx = filePath.lastIndexOf("/");
        if (fileNameIdx >= 0) {
            fileName = filePath.substring(fileNameIdx + 1);
            path = filePath.substring(0, fileNameIdx);
        }
        try {
            return this.publishFile(path, fileName, new ByteArrayInputStream(data), true);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new IOException(ex);
        }
    }

    public int publishFile(String repositoryPath, String fileName, InputStream fileInputStream, boolean overwriteIfExists) throws IOException {
        String url = this.baseUrl + REPO_FILES_IMPORT;
        WebResource resource = this.client.resource(url);
        int responseCode = 504;
        try {
            FormDataMultiPart part = new FormDataMultiPart();
            String pathEncoded = URLEncoder.encode(repositoryPath + "/" + fileName, "UTF-8");
            String nameEncoded = URLEncoder.encode(fileName, "UTF-8");
            part.field("importPath", (Object)pathEncoded, MediaType.MULTIPART_FORM_DATA_TYPE);
            part.field("fileUpload", (Object)fileInputStream, MediaType.MULTIPART_FORM_DATA_TYPE);
            part.field("overwriteFile", (Object)Boolean.toString(overwriteIfExists), MediaType.MULTIPART_FORM_DATA_TYPE);
            part.getField("fileUpload").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"fileUpload").fileName(nameEncoded)).build());
            WebResource.Builder builder = resource.type(MediaType.MULTIPART_FORM_DATA_TYPE);
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)part);
            if (response != null) {
                String message = (String)response.getEntity(String.class);
                logger.info((Object)message);
                responseCode = response.getStatus();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return responseCode;
    }
}

