/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol.vfs;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FileInfo {
    private boolean directory;
    private boolean visible;
    private String name;
    private String localizedName;
    private String description;
    private long lastModifiedDate;
    private String parameterServiceURL;
    private String title;
    private String url;
    private FileInfo parent;
    private ArrayList<FileInfo> childs;

    public FileInfo() {
        this.directory = true;
        this.visible = true;
        this.name = "";
        this.localizedName = "";
        this.description = "Content Root";
        this.lastModifiedDate = System.currentTimeMillis();
        this.childs = new ArrayList();
    }

    public FileInfo(FileInfo parent, String name, String description) {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.directory = true;
        this.visible = true;
        this.name = name;
        this.localizedName = "";
        this.description = description;
        this.lastModifiedDate = System.currentTimeMillis();
        this.childs = new ArrayList();
        this.parent = parent;
        this.parent.childs.add(this);
    }

    public FileInfo(FileInfo parent, Attributes element) throws SAXException {
        if (parent == null) {
            throw new SAXException();
        }
        if (element == null) {
            throw new SAXException();
        }
        this.name = element.getValue("name");
        if (this.name == null) {
            throw new IllegalStateException("<name> attribute is null. Your BI-Server serves incorrect solution-repository files.");
        }
        this.localizedName = element.getValue("localized-name");
        if (this.localizedName == null) {
            this.localizedName = this.name;
        }
        this.directory = "true".equals(element.getValue("isDirectory"));
        this.visible = "true".equals(element.getValue("visible"));
        String lastModifiedRaw = element.getValue("lastModifiedDate");
        if (lastModifiedRaw != null) {
            try {
                this.lastModifiedDate = Long.parseLong(lastModifiedRaw);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException();
            }
        }
        this.description = element.getValue("description");
        this.title = element.getValue("title");
        if (this.title == null) {
            this.title = element.getValue("url_name");
        }
        this.url = element.getValue("url");
        this.parameterServiceURL = element.getValue("param-service-url");
        this.childs = new ArrayList();
        this.parent = parent;
        this.parent.childs.add(this);
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getParameterServiceURL() {
        return this.parameterServiceURL;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public FileInfo getParent() {
        return this.parent;
    }

    public FileInfo[] getChilds() {
        return this.childs.toArray(new FileInfo[this.childs.size()]);
    }

    public FileInfo getChild(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.childs.size(); ++i) {
            FileInfo fileInfo = this.childs.get(i);
            if (!name.equals(fileInfo.getName())) continue;
            return fileInfo;
        }
        return null;
    }
}

