/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.MemoryByteArrayOutputStream;
import org.pentaho.reporting.libraries.pensol.LibPensolBoot;
import org.pentaho.reporting.libraries.pensol.vfs.FileInfo;
import org.pentaho.reporting.libraries.pensol.vfs.XmlSolutionFileModel;

public class LocalFileModel
extends XmlSolutionFileModel {
    private static final Log logger = LogFactory.getLog(LocalFileModel.class);
    private String url;
    private String username;
    private String password;
    private HttpClient client;

    public LocalFileModel(String url, HttpClient client, String username, String password) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.username = username;
        this.password = password;
        this.client = client;
        this.client.getParams().setCookiePolicy("compatibility");
        this.client.getParams().setParameter("http.protocol.max-redirects", (Object)10);
        this.client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.TRUE);
        this.client.getParams().setParameter("http.protocol.reject-relative-redirect", (Object)Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws IOException {
        int lastStatus;
        this.getDescriptionEntries().clear();
        Configuration configuration = LibPensolBoot.getInstance().getGlobalConfig();
        String service = configuration.getConfigProperty("org.pentaho.reporting.libraries.pensol.web.LoadRepositoryDoc");
        PostMethod filePost = new PostMethod(this.url + service);
        logger.debug((Object)("Connecting to '" + this.url + service + '\''));
        filePost.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        if (this.username != null) {
            filePost.addParameter("userid", this.username);
        }
        if (this.password != null) {
            filePost.addParameter("password", this.password);
        }
        if ((lastStatus = this.client.executeMethod((HttpMethod)filePost)) == 401) {
            throw new IOException("401: User authentication failed.");
        }
        if (lastStatus == 404) {
            throw new IOException("404: Repository service not found on server.");
        }
        if (lastStatus != 200) {
            throw new IOException("Server error: HTTP lastStatus code " + lastStatus);
        }
        try (InputStream postResult = filePost.getResponseBodyAsStream();){
            this.setRoot(this.performParse(postResult));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] getDataInternally(FileInfo fileInfo) throws FileSystemException {
        byte[] byArray;
        PostMethod filePost = new PostMethod(fileInfo.getUrl());
        filePost.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        if (this.username != null) {
            filePost.addParameter("userid", this.username);
        }
        if (this.password != null) {
            filePost.addParameter("password", this.password);
        }
        int lastStatus = this.client.executeMethod((HttpMethod)filePost);
        if (lastStatus == 401) {
            throw new FileSystemException("401: User authentication failed.");
        }
        if (lastStatus == 404) {
            throw new FileSystemException("404: Repository service not found on server.");
        }
        if (lastStatus != 200) {
            throw new FileSystemException("Server error: HTTP lastStatus code " + lastStatus);
        }
        InputStream postResult = filePost.getResponseBodyAsStream();
        try {
            MemoryByteArrayOutputStream bout = new MemoryByteArrayOutputStream();
            IOUtils.getInstance().copyStreams(postResult, (OutputStream)bout);
            byArray = bout.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                postResult.close();
                throw throwable;
            }
            catch (FileSystemException ioe) {
                throw ioe;
            }
            catch (IOException ioe) {
                throw new FileSystemException("Failed", (Throwable)ioe);
            }
        }
        postResult.close();
        return byArray;
    }

    @Override
    public void createFolder(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        if (fileName.length < 2) {
            throw new FileSystemException("Cannot create directory in the root.");
        }
        String[] parentPath = new String[fileName.length - 1];
        System.arraycopy(fileName, 0, parentPath, 0, parentPath.length);
        FileInfo fileInfo = this.lookupNode(parentPath);
        if (fileInfo == null) {
            throw new FileSystemException("Cannot locate parent directory.");
        }
        try {
            String solution = fileName[0];
            String path = this.buildPath(fileName, 1, fileName.length - 1);
            String name = fileName[fileName.length - 1];
            String description = this.getDescriptionEntries().get(file);
            if (description == null) {
                description = "";
            }
            Configuration config = LibPensolBoot.getInstance().getGlobalConfig();
            String urlMessage = config.getConfigProperty("org.pentaho.reporting.libraries.pensol.web.CreateNewFolder");
            MessageFormat fmt = new MessageFormat(urlMessage);
            String fullpath = fmt.format(new Object[]{URLEncoder.encode(solution, "UTF-8"), URLEncoder.encode(path, "UTF-8"), URLEncoder.encode(name, "UTF-8"), URLEncoder.encode(description, "UTF-8")});
            PostMethod filePost = new PostMethod(this.url + fullpath);
            if (this.username != null) {
                filePost.addParameter("user", this.username);
            }
            if (this.password != null) {
                filePost.addParameter("password", this.password);
            }
            filePost.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            int lastStatus = this.client.executeMethod((HttpMethod)filePost);
            if (lastStatus != 200) {
                throw new FileSystemException("Server error: HTTP status code " + lastStatus);
            }
            if (name == null) {
                throw new FileSystemException("Error creating folder: Empty name");
            }
            new FileInfo(fileInfo, name, description);
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (IOException ioe) {
            throw new FileSystemException("Failed", (Throwable)ioe);
        }
    }

    private String buildPath(String[] fileName, int index, int endIndex) {
        StringBuilder b = new StringBuilder(100);
        for (int i = index; i < endIndex; ++i) {
            if (i != index) {
                b.append('/');
            }
            b.append(fileName[i]);
        }
        return b.toString();
    }

    @Override
    public long getContentSize(FileName name) throws FileSystemException {
        return 0L;
    }

    @Override
    protected void setDataInternally(FileInfo fileInfo, byte[] data) throws FileSystemException {
        throw new FileSystemException("Not supported");
    }

    @Override
    public boolean delete(FileName name) throws FileSystemException {
        throw new FileSystemException("Not supported");
    }
}

