/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.json;

import com.sun.javafx.data.json.JSONSymbol;
import com.sun.javafx.data.pull.impl.Position;
import com.sun.javafx.data.pull.impl.StreamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class JSONScanner
implements Position {
    private Reader reader;
    private String value;
    private int prevChar;
    private int x;
    private int y = 1;
    private int checkpointX;
    private int checkpointY;
    private int offset;
    private boolean isInt;

    public JSONScanner(InputStream is, String encoding) throws StreamException, IOException {
        this.reader = new InputStreamReader(is, encoding);
        this.offset = 0;
        this.prevChar = this.reader.read();
    }

    JSONSymbol nextSymbol() throws StreamException, IOException {
        JSONSymbol s;
        int ch = this.prevChar;
        while (ch != -1 && (ch == 32 || ch == 9 || ch == 12 || ch == 10 || ch == 13)) {
            ch = this.readChar(true);
        }
        this.value = null;
        switch (ch) {
            case -1: {
                s = JSONSymbol.EOS;
                this.prevChar = -1;
                break;
            }
            case 123: {
                s = JSONSymbol.CURLYOPEN;
                this.prevChar = this.readChar(true);
                break;
            }
            case 125: {
                s = JSONSymbol.CURLYCLOSE;
                this.prevChar = this.readChar(true);
                break;
            }
            case 91: {
                s = JSONSymbol.SQUAREOPEN;
                this.prevChar = this.readChar(true);
                break;
            }
            case 93: {
                s = JSONSymbol.SQUARECLOSE;
                this.prevChar = this.readChar(true);
                break;
            }
            case 58: {
                s = JSONSymbol.COLON;
                this.prevChar = this.readChar(true);
                break;
            }
            case 44: {
                s = JSONSymbol.COMMA;
                this.prevChar = this.readChar(true);
                break;
            }
            case 116: {
                this.readKeyword("true");
                s = JSONSymbol.KEYWORD;
                break;
            }
            case 102: {
                this.readKeyword("false");
                s = JSONSymbol.KEYWORD;
                break;
            }
            case 110: {
                this.readKeyword("null");
                s = JSONSymbol.KEYWORD;
                break;
            }
            case 34: {
                this.value = this.readString();
                s = JSONSymbol.STRING;
                break;
            }
            case 45: {
                this.value = this.readNumber(ch);
                s = JSONSymbol.NUMBER;
                break;
            }
            default: {
                if (ch >= 48 && ch <= 57) {
                    this.value = this.readNumber(ch);
                    s = JSONSymbol.NUMBER;
                    break;
                }
                throw new StreamException("Unexpected character '" + (char)ch + "'", this);
            }
        }
        return s;
    }

    public String getValue() {
        return this.value;
    }

    public Position getLocation() {
        return this;
    }

    private void readKeyword(String text) throws StreamException, IOException {
        int i;
        int ch = 0;
        for (i = 1; i < text.length() && (ch = this.readChar(false)) == text.charAt(i); ++i) {
        }
        if (i < text.length()) {
            throw new StreamException("Unexpected character '" + (char)ch + "'", this);
        }
        this.value = text;
        this.prevChar = this.readChar(true);
    }

    private String readString() throws StreamException, IOException {
        int ch;
        StringBuilder val = new StringBuilder();
        do {
            ch = this.readChar(false);
            block0 : switch (ch) {
                case -1: {
                    throw new StreamException("Unexpected end of stream", this);
                }
                case 92: {
                    int ch2 = this.readChar(false);
                    switch (ch2) {
                        case 34: 
                        case 47: 
                        case 92: {
                            val.append((char)ch2);
                            break block0;
                        }
                        case 98: {
                            val.append('\b');
                            break block0;
                        }
                        case 102: {
                            val.append('\f');
                            break block0;
                        }
                        case 110: {
                            val.append('\n');
                            break block0;
                        }
                        case 114: {
                            val.append('\r');
                            break block0;
                        }
                        case 116: {
                            val.append('\t');
                            break block0;
                        }
                        case 117: {
                            int unicode = 0;
                            int i = 4;
                            while (--i >= 0) {
                                ch2 = this.readChar(false);
                                unicode = (char)(unicode << 4);
                                if (ch2 >= 48 && ch2 <= 57) {
                                    unicode = (char)(unicode | (char)ch2 - 48);
                                    continue;
                                }
                                if (ch2 >= 97 && ch2 <= 102) {
                                    unicode = (char)(unicode | (char)ch2 - 97 + 10);
                                    continue;
                                }
                                if (ch2 >= 65 && ch2 <= 70) {
                                    unicode = (char)(unicode | (char)ch2 - 65 + 10);
                                    continue;
                                }
                                throw new StreamException("Unexpected character '" + ch2 + "'", this);
                            }
                            val.append((char)(unicode & 0xFFFF));
                            break block0;
                        }
                    }
                    throw new StreamException("Unexpected character '" + ch2 + "'", this);
                }
                case 34: {
                    break;
                }
                default: {
                    if (ch >= 0 && ch <= 31 || ch >= 127 && ch <= 159) {
                        throw new StreamException("Control character is not allowed inside string", this);
                    }
                    val.append((char)ch);
                }
            }
        } while (ch != 34);
        this.prevChar = this.readChar(true);
        return val.toString();
    }

    private String readNumber(int prefetch) throws StreamException, IOException {
        int count;
        int ch = prefetch;
        StringBuilder val = new StringBuilder();
        val.append((char)ch);
        if (ch == 45) {
            ch = this.readChar(true);
            val.append((char)ch);
            if (ch < 48 || ch > 57) {
                throw new StreamException("Unexpected character '" + (char)ch + "'", this);
            }
        }
        this.isInt = true;
        if (ch == 48) {
            ch = this.readChar(true);
            val.append((char)ch);
        } else {
            do {
                ch = this.readChar(true);
                val.append((char)ch);
            } while (ch >= 48 && ch <= 57);
        }
        if (ch == 46) {
            this.isInt = false;
            count = 0;
            do {
                ch = this.readChar(true);
                val.append((char)ch);
                ++count;
            } while (ch >= 48 && ch <= 57);
            if (count == 1) {
                throw new StreamException("Unexpected character '" + (char)ch + "'", this);
            }
        }
        if (ch == 101 || ch == 69) {
            this.isInt = false;
            ch = this.readChar(false);
            val.append((char)ch);
            if (ch == 43 || ch == 45) {
                ch = this.readChar(false);
                val.append((char)ch);
            }
            count = 0;
            while (ch >= 48 && ch <= 57) {
                ch = this.readChar(true);
                val.append((char)ch);
                ++count;
            }
            if (count == 0) {
                throw new StreamException("Unexpected character '" + (char)ch + "'", this);
            }
        }
        this.prevChar = ch;
        return val.toString().substring(0, val.length() - 1);
    }

    private int readChar(boolean checkpoint) throws IOException {
        int ch = this.reader.read();
        if (checkpoint) {
            this.checkpointX = this.x;
            this.checkpointY = this.y;
        }
        if (ch == 10) {
            ++this.y;
            this.x = 0;
        } else {
            ++this.x;
        }
        ++this.offset;
        return ch;
    }

    public boolean isInteger() {
        return this.isInt;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int line() {
        return this.y;
    }

    public int column() {
        return this.x;
    }

    public int getCharacterOffset() {
        return this.offset;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public String toString() {
        return this.y + ":" + this.x + (this.offset >= 0 ? "@" + this.offset : "");
    }
}

