/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.pull.ukit.xml;

import com.sun.javafx.data.pull.ukit.xml.Pair;

public class Attrs {
    private Pair mElm;
    private int mLength;
    String[] mItems = new String[64];

    Attrs() {
    }

    void set(Pair elm) {
        this.mElm = elm;
        this.mLength = -1;
    }

    private void update() {
        if (this.mElm.num > this.mItems.length >> 3) {
            this.mItems = new String[this.mElm.num << 3];
        }
        boolean withns = (this.mElm.id & 1) != 0;
        int idx = 0;
        Pair attr = this.mElm.list;
        while (attr != null) {
            if (attr.list == null || !withns) {
                int base = idx << 3;
                ++idx;
                this.mItems[base] = attr.ns != null ? attr.ns : "";
                this.mItems[base + 1] = attr.qname();
                this.mItems[base + 2] = withns ? attr.local() : "";
                this.mItems[base + 3] = attr.value;
                switch (attr.id) {
                    case 105: {
                        this.mItems[base + 4] = "ID";
                        break;
                    }
                    case 114: {
                        this.mItems[base + 4] = "IDREF";
                        break;
                    }
                    case 82: {
                        this.mItems[base + 4] = "IDREFS";
                        break;
                    }
                    case 110: {
                        this.mItems[base + 4] = "ENTITY";
                        break;
                    }
                    case 78: {
                        this.mItems[base + 4] = "ENTITIES";
                        break;
                    }
                    case 116: {
                        this.mItems[base + 4] = "NMTOKEN";
                        break;
                    }
                    case 84: {
                        this.mItems[base + 4] = "NMTOKENS";
                        break;
                    }
                    case 117: {
                        this.mItems[base + 4] = "NMTOKEN";
                        break;
                    }
                    case 111: {
                        this.mItems[base + 4] = "NOTATION";
                        break;
                    }
                    default: {
                        this.mItems[base + 4] = "CDATA";
                    }
                }
                switch (attr.num & 3) {
                    case 0: {
                        this.mItems[base + 5] = null;
                        break;
                    }
                    case 1: {
                        this.mItems[base + 5] = "d";
                        break;
                    }
                    default: {
                        this.mItems[base + 5] = "D";
                    }
                }
            }
            attr = attr.next;
        }
        this.mLength = idx;
    }

    public int getLength() {
        if (this.mLength < 0) {
            this.update();
        }
        return this.mLength;
    }

    public String getURI(int index) {
        if (this.mLength < 0) {
            this.update();
        }
        return index >= 0 && index < this.mLength ? this.mItems[index << 3] : null;
    }

    public String getLocalName(int index) {
        if (this.mLength < 0) {
            this.update();
        }
        return index >= 0 && index < this.mLength ? this.mItems[(index << 3) + 2] : null;
    }

    public String getQName(int index) {
        if (this.mLength < 0) {
            this.update();
        }
        if (index < 0 || index >= this.mLength) {
            return null;
        }
        return this.mItems[(index << 3) + 1];
    }

    public String getType(int index) {
        if (this.mLength < 0) {
            this.update();
        }
        return index >= 0 && index < this.mItems.length >> 3 ? this.mItems[(index << 3) + 4] : null;
    }

    public String getValue(int index) {
        if (this.mLength < 0) {
            this.update();
        }
        return index >= 0 && index < this.mLength ? this.mItems[(index << 3) + 3] : null;
    }

    public int getIndex(String uri, String localName) {
        if (this.mLength < 0) {
            this.update();
        }
        int len = this.mLength;
        for (int idx = 0; idx < len; ++idx) {
            if (!this.mItems[idx << 3].equals(uri) || !this.mItems[(idx << 3) + 2].equals(localName)) continue;
            return idx;
        }
        return -1;
    }

    int getIndexNullNS(String uri, String localName) {
        if (this.mLength < 0) {
            this.update();
        }
        int len = this.mLength;
        if (uri != null) {
            for (int idx = 0; idx < len; ++idx) {
                if (!this.mItems[idx << 3].equals(uri) || !this.mItems[(idx << 3) + 2].equals(localName)) continue;
                return idx;
            }
        } else {
            for (int idx = 0; idx < len; ++idx) {
                if (!this.mItems[(idx << 3) + 2].equals(localName)) continue;
                return idx;
            }
        }
        return -1;
    }

    public int getIndex(String qName) {
        if (this.mLength < 0) {
            this.update();
        }
        int len = this.mLength;
        for (int idx = 0; idx < len; ++idx) {
            if (!this.mItems[(idx << 3) + 1].equals(qName)) continue;
            return idx;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        int idx;
        if (this.mLength < 0) {
            this.update();
        }
        return (idx = this.getIndex(uri, localName)) >= 0 ? this.mItems[(idx << 3) + 4] : null;
    }

    public String getType(String qName) {
        int idx;
        if (this.mLength < 0) {
            this.update();
        }
        return (idx = this.getIndex(qName)) >= 0 ? this.mItems[(idx << 3) + 4] : null;
    }

    public String getValue(String uri, String localName) {
        int idx;
        if (this.mLength < 0) {
            this.update();
        }
        return (idx = this.getIndex(uri, localName)) >= 0 ? this.mItems[(idx << 3) + 3] : null;
    }

    public String getValue(String qName) {
        int idx;
        if (this.mLength < 0) {
            this.update();
        }
        return (idx = this.getIndex(qName)) >= 0 ? this.mItems[(idx << 3) + 3] : null;
    }

    public boolean isDeclared(int index) {
        if (this.mLength < 0) {
            this.update();
        }
        if (index < 0 || index >= this.mLength) {
            throw new ArrayIndexOutOfBoundsException("");
        }
        return this.mItems[(index << 3) + 5] != null;
    }

    public boolean isDeclared(String qName) {
        int idx;
        if (this.mLength < 0) {
            this.update();
        }
        if ((idx = this.getIndex(qName)) < 0) {
            throw new IllegalArgumentException("");
        }
        return this.mItems[(idx << 3) + 5] != null;
    }

    public boolean isDeclared(String uri, String localName) {
        int idx;
        if (this.mLength < 0) {
            this.update();
        }
        if ((idx = this.getIndex(uri, localName)) < 0) {
            throw new IllegalArgumentException("");
        }
        return this.mItems[(idx << 3) + 5] != null;
    }

    public boolean isSpecified(int index) {
        if (this.mLength < 0) {
            this.update();
        }
        if (index < 0 || index >= this.mLength) {
            throw new ArrayIndexOutOfBoundsException("");
        }
        String str = this.mItems[(index << 3) + 5];
        return str != null ? str.charAt(0) == 'd' : true;
    }

    public boolean isSpecified(String uri, String localName) {
        int idx;
        if (this.mLength < 0) {
            this.update();
        }
        if ((idx = this.getIndex(uri, localName)) < 0) {
            throw new IllegalArgumentException("");
        }
        String str = this.mItems[(idx << 3) + 5];
        return str != null ? str.charAt(0) == 'd' : true;
    }

    public boolean isSpecified(String qName) {
        int idx;
        if (this.mLength < 0) {
            this.update();
        }
        if ((idx = this.getIndex(qName)) < 0) {
            throw new IllegalArgumentException("");
        }
        String str = this.mItems[(idx << 3) + 5];
        return str != null ? str.charAt(0) == 'd' : true;
    }
}

