/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl;

import com.sun.javafx.io.http.impl.DefaultProfile;
import com.sun.javafx.io.http.impl.Profile;
import com.sun.javafx.io.http.impl.Progress;
import com.sun.javafx.io.http.impl.Request;
import com.sun.javafx.io.http.impl.Task;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseTask
implements Task {
    private static final int NOTIFICATION_COUNT = 25;
    public final int id;
    protected final Request request;
    protected final Progress progress;
    protected final Profile profile;
    private volatile boolean cancel = false;

    protected BaseTask(int id, Request request, Progress progress, Profile profile) {
        this.id = id;
        this.request = request;
        this.progress = progress;
        this.profile = profile;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setDone() {
        this.notifyDone();
    }

    @Override
    public void setException(Exception ex) {
        this.notifyException(ex);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseTask) {
            BaseTask other = (BaseTask)obj;
            return this.id == other.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "{id: " + this.id + "}";
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    public int optimalChunkSize(long size) {
        if (size > (long)DefaultProfile.load().getMaxChunkSize() || size < 0L) {
            return DefaultProfile.load().getMaxChunkSize();
        }
        if (size < (long)DefaultProfile.load().getMinChunkSize()) {
            return DefaultProfile.load().getMinChunkSize();
        }
        return (int)(size / 25L);
    }

    protected void notifyStart() {
        this.profile.deferTask(new StartNotifier(this.progress));
    }

    protected void notifyConnect(boolean start) {
        this.profile.deferTask(new ConnectNotifier(this.progress, start));
    }

    protected void notifyHeaders(boolean start) {
        this.profile.deferTask(new HeadersNotifier(this.progress, start));
    }

    protected void notifyDone() {
        this.profile.deferTask(new DoneNotifier(this.progress));
    }

    protected void notifyRead(boolean start) throws IOException {
        this.profile.deferTask(new ReadNotifier(this.progress, start));
    }

    protected void notifyInput(InputStream is) throws IOException {
        this.profile.deferTask(new ReadNotifier(this.progress, is));
    }

    protected void notifyWrite(boolean start) throws IOException {
        this.profile.deferTask(new WriteNotifier(this.progress, start));
    }

    protected void notifyOutput(OutputStream os) throws IOException {
        this.profile.deferTask(new WriteNotifier(this.progress, os));
    }

    protected void notifyException(Exception ex) {
        this.profile.deferTask(new ExceptionNotifier(this.progress, ex));
    }

    protected void notifyProgress(boolean isread, boolean ismax, long value) {
        this.profile.deferTask(new ProgressNotifier(this.progress, isread, ismax, value));
    }

    @Override
    public abstract void run();

    public abstract OutputStream getOutputStream(Map<String, String> var1) throws IOException;

    public abstract InputStream getInputStream(Map<String, String> var1) throws IOException;

    static final class ConnectNotifier
    extends Notifier {
        private final boolean start;

        ConnectNotifier(Progress progress, boolean start) {
            super(progress);
            this.start = start;
        }

        public void run() {
            if (this.start) {
                this.progress.setConnecting();
            } else {
                this.progress.setDoneConnect();
            }
        }
    }

    static final class DoneNotifier
    extends Notifier {
        DoneNotifier(Progress progress) {
            super(progress);
        }

        public void run() {
            this.progress.setDone();
        }
    }

    static final class ExceptionNotifier
    extends Notifier {
        private final Exception ex;

        ExceptionNotifier(Progress progress, Exception ex) {
            super(progress);
            this.ex = ex;
        }

        public void run() {
            this.progress.setException(this.ex);
        }
    }

    static final class HeadersNotifier
    extends Notifier {
        private final boolean start;

        HeadersNotifier(Progress progress, boolean start) {
            super(progress);
            this.start = start;
        }

        public void run() {
            if (this.start) {
                this.progress.setReadingHeaders();
            } else {
                this.progress.setDoneHeaders();
            }
        }
    }

    static abstract class Notifier
    implements Runnable {
        protected final Progress progress;

        Notifier(Progress progress) {
            this.progress = progress;
        }

        public abstract void run();
    }

    static final class ProgressNotifier
    extends Notifier {
        private final boolean isread;
        private final boolean ismax;
        private final long value;

        ProgressNotifier(Progress progress, boolean isread, boolean ismax, long value) {
            super(progress);
            this.isread = isread;
            this.ismax = ismax;
            this.value = value;
        }

        public void run() {
            if (this.isread) {
                if (this.ismax) {
                    this.progress.setToRead(this.value);
                } else {
                    this.progress.setRead(this.value);
                }
            } else if (this.ismax) {
                this.progress.setToWrite(this.value);
            } else {
                this.progress.setWritten(this.value);
            }
        }
    }

    static final class ReadNotifier
    extends Notifier {
        private final InputStream is;
        private final boolean start;

        ReadNotifier(Progress progress, boolean start) {
            super(progress);
            this.is = null;
            this.start = start;
        }

        ReadNotifier(Progress progress, InputStream is) {
            super(progress);
            this.is = is;
            this.start = false;
        }

        public void run() {
            if (this.is != null) {
                this.progress.setInput(this.is);
            } else if (this.start) {
                this.progress.setReading();
            } else {
                this.progress.setDoneRead();
            }
        }
    }

    static final class StartNotifier
    extends Notifier {
        StartNotifier(Progress progress) {
            super(progress);
        }

        public void run() {
            this.progress.setDoneStart();
        }
    }

    static final class WriteNotifier
    extends Notifier {
        private final OutputStream os;
        private final boolean start;

        WriteNotifier(Progress progress, boolean start) {
            super(progress);
            this.os = null;
            this.start = start;
        }

        WriteNotifier(Progress progress, OutputStream os) {
            super(progress);
            this.os = os;
            this.start = false;
        }

        public void run() {
            if (this.os != null) {
                this.progress.setOutput(this.os);
            } else if (this.start) {
                this.progress.setWriting();
            } else {
                this.progress.setDoneWrite();
            }
        }
    }
}

