/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl;

import com.sun.javafx.io.http.impl.BaseTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class WaitingOutputStream
extends ByteArrayOutputStream {
    private final OutputStream os;
    private volatile boolean closed = false;

    public WaitingOutputStream(OutputStream out, int size) {
        super(size);
        this.os = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        this.closed = true;
        WaitingOutputStream waitingOutputStream = this;
        synchronized (waitingOutputStream) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilClosed() throws InterruptedException {
        while (!this.closed) {
            WaitingOutputStream waitingOutputStream = this;
            synchronized (waitingOutputStream) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(BaseTask status, long size) throws IOException {
        try {
            if (status.isCancelled()) {
                throw new InterruptedIOException("Cancelled");
            }
            if (size > Integer.MAX_VALUE) {
                throw new IOException("can't transfer because buffer size (" + size + ") exceeds Integer.MAX_VALUE");
            }
            status.notifyProgress(false, true, this.count);
            int offset = 0;
            int bufferSize = status.optimalChunkSize(size);
            while (offset < this.count) {
                if (status.isCancelled()) {
                    throw new InterruptedIOException("Cancelled");
                }
                int chunksize = Math.min(this.count - offset, bufferSize);
                this.os.write(this.buf, offset, chunksize);
                status.notifyProgress(false, false, offset += chunksize);
            }
        }
        finally {
            this.os.close();
        }
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }
}

