/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl.desktop;

import com.sun.javafx.io.http.impl.Connection;
import com.sun.javafx.util.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class DesktopConnection
implements Connection {
    private URLConnection connection;

    public void open(String location) throws IOException {
        URL url = new URL(location);
        this.connection = url.openConnection();
    }

    public void setMethod(String method) throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)this.connection;
            http.setRequestMethod(method);
            this.connection.setDoInput(true);
            if ("POST".equals(method) || "PUT".equals(method)) {
                this.connection.setDoOutput(true);
            }
        }
    }

    public void setRequestProperty(String name, String value) throws IOException {
        this.connection.setRequestProperty(name, value);
    }

    public void connect() throws IOException {
        try {
            this.connection.connect();
        }
        catch (SecurityException se) {
            if (Platform.checkConnectAcrossDomain((URL)this.connection.getURL())) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            DesktopConnection.this.connection.connect();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    if (cause.getClass() == IOException.class) {
                        throw (IOException)cause;
                    }
                    if (cause.getClass() == RuntimeException.class) {
                        throw (RuntimeException)cause;
                    }
                    IOException ioe = new IOException();
                    ioe.initCause(cause);
                    throw ioe;
                }
            }
            throw se;
        }
    }

    public void close() throws IOException {
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public InputStream getErrorStream() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getErrorStream();
        }
        return null;
    }

    public int getResponseCode() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getResponseCode();
        }
        return 0;
    }

    public String getResponseMessage() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getResponseMessage();
        }
        return null;
    }

    public String getHeaderFieldKey(int index) throws IOException {
        return this.connection.getHeaderFieldKey(index);
    }

    public String getHeaderField(int index) throws IOException {
        return this.connection.getHeaderField(index);
    }
}

