/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl.desktop;

import com.sun.javafx.functions.Function0;
import com.sun.javafx.io.http.impl.Connection;
import com.sun.javafx.io.http.impl.HttpTask;
import com.sun.javafx.io.http.impl.Profile;
import com.sun.javafx.io.http.impl.Task;
import com.sun.javafx.io.http.impl.desktop.DesktopConnection;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.lang.FX;

public final class DesktopProfile
implements Profile {
    private static final int CORE_POOL_SIZE = 8;
    private static final int MAX_POOL_SIZE = 64;
    private static final long KEEP_ALIVE_SECONDS = 30L;
    private static final Logger LOG = Logger.getLogger(DesktopProfile.class.getName());
    private static final BlockingQueue<Runnable> ioQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadGroup threadGroup = new ThreadGroup("request io pool");
    private static final Thread.UncaughtExceptionHandler uncaughtHandler = new Thread.UncaughtExceptionHandler(){

        public void uncaughtException(Thread thread, Throwable throwable) {
            if (!(throwable instanceof IllegalMonitorStateException)) {
                LOG.log(Level.WARNING, "Uncaught throwable in " + threadGroup.getName(), throwable);
            }
        }
    };
    private static final ThreadFactory threadFactory = new ThreadFactory(){

        public Thread newThread(Runnable run) {
            Thread th = new Thread(threadGroup, run);
            th.setDaemon(true);
            th.setUncaughtExceptionHandler(uncaughtHandler);
            return th;
        }
    };
    private static final ThreadPoolExecutor executor = new IOThreadPoolExecutor(8, 64, 30L, TimeUnit.SECONDS, ioQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
    private static final Queue<IOTask> activeTasks = new ConcurrentLinkedQueue<IOTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task) {
        BlockingQueue<Runnable> blockingQueue = ioQueue;
        synchronized (blockingQueue) {
            executor.execute(new IOTask(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int id) {
        BlockingQueue<Runnable> blockingQueue = ioQueue;
        synchronized (blockingQueue) {
            Iterator ti = ioQueue.iterator();
            while (ti.hasNext()) {
                Runnable run = (Runnable)ti.next();
                if (!(run instanceof IOTask)) continue;
                IOTask iot = (IOTask)run;
                if (iot.task.getId() != id) continue;
                iot.task.cancel();
                iot.cancel(true);
                ti.remove();
                break;
            }
        }
        for (IOTask iot : activeTasks) {
            if (iot.task.getId() != id) continue;
            iot.task.cancel();
            iot.cancel(true);
            break;
        }
    }

    public void shutdown() {
        executor.shutdown();
    }

    public void shutdownNow() {
        executor.shutdownNow();
    }

    public void deferTask(final Runnable runnable) {
        FX.deferAction((Function0)new Function0<Void>(){

            public Void invoke() {
                runnable.run();
                return null;
            }
        });
    }

    public String encodeURL(String params) {
        try {
            return HttpTask.encodeURL(params, false, false);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.log(Level.WARNING, "unable to encode params " + params, ex);
            return null;
        }
    }

    public String encodeURL(String params, boolean encodeAsterisk, boolean encodeSpaceAsPercent) {
        try {
            return HttpTask.encodeURL(params, encodeAsterisk, encodeSpaceAsPercent);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.log(Level.WARNING, "unable to encode params " + params, ex);
            return null;
        }
    }

    public String decodeURL(String params) {
        try {
            return URLDecoder.decode(params, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.log(Level.WARNING, "unable to decode params " + params, ex);
            return null;
        }
    }

    public Connection newConnection() {
        return new DesktopConnection();
    }

    public String name() {
        return "desktop";
    }

    public int getMaxChunkSize() {
        return 65536;
    }

    public int getMinChunkSize() {
        return 512;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IOTask
    extends FutureTask<Object> {
        final Task task;

        IOTask(Task task) {
            super(Executors.callable(task));
            this.task = task;
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
            if (t instanceof Exception) {
                this.task.setException((Exception)t);
            } else {
                this.task.setException(new RuntimeException(t));
            }
        }

        @Override
        protected void done() {
            this.task.setDone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IOThreadPoolExecutor
    extends ThreadPoolExecutor {
        public IOThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            if (r instanceof IOTask) {
                IOTask iot = (IOTask)r;
                activeTasks.add(iot);
                String name = "io." + iot.task.getId();
                t.setName(name);
                LOG.finer(threadGroup.getName() + ": starting " + name);
            }
            super.beforeExecute(t, r);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (r instanceof IOTask) {
                IOTask iot = (IOTask)r;
                activeTasks.remove(iot);
                String name = "io." + iot.task.getId();
                LOG.finer(threadGroup.getName() + ": done " + name);
            }
        }
    }
}

