/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppitf.anzeige.components;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sportdata.setppitf.anzeige.AnzeigeController;
import org.sportdata.setppitf.anzeige.constants.MainConstants;
import org.sportdata.setppitf.anzeige.interfaces.IAnzeigeEventListener;
import org.sportdata.setppitf.anzeige.properties.helper.AnzeigePropertiesHelper;

public class AKAWarningFoulComponent
extends JPanel
implements IAnzeigeEventListener {
    private static final long serialVersionUID = -1295753154920288726L;
    private int a = 3;
    private Color b = MainConstants.AKA_COLOR;
    private Color c;
    private JLabel d = new JLabel("WA");
    private JLabel e = new JLabel(" 0 ");
    private JLabel f = new JLabel("FO");
    private JLabel g = new JLabel(" 0 ");
    private JLabel h = new JLabel("MI");
    private JLabel i = new JLabel(" 0 ");
    private int j = 0;
    private int k = 0;
    private AnzeigeController l;
    private boolean m;
    private JPanel n;

    public AKAWarningFoulComponent(Color colorb, int mode, AnzeigeController acontrol, boolean logging) {
        this.c = colorb;
        this.a = mode;
        this.l = acontrol;
        this.m = logging;
        this.setOpaque(false);
        this.setBackground(this.c);
        this.initComponent();
        this.registerPanel();
        this.reset();
    }

    @Override
    public void registerPanel() {
        this.l.getListeners(this.a).add(this);
    }

    public void initComponent() {
        this.n = new JPanel();
        this.n.setBackground(this.c);
        this.d.setFont(MainConstants.DISPLAY_FONT_AKAAO_SANKTIONS_BIG[this.a]);
        this.e.setFont(MainConstants.DISPLAY_FONT_AKAAO_SANKTIONS_BIG[this.a]);
        this.f.setFont(MainConstants.DISPLAY_FONT_AKAAO_SANKTIONS_BIG[this.a]);
        this.g.setFont(MainConstants.DISPLAY_FONT_AKAAO_SANKTIONS_BIG[this.a]);
        this.d.setForeground(this.b);
        this.e.setForeground(this.b);
        this.f.setForeground(this.b);
        this.g.setForeground(this.b);
        this.h.setFont(MainConstants.DISPLAY_FONT_AKAAO_SANKTIONS_BIG[this.a]);
        this.i.setFont(MainConstants.DISPLAY_FONT_AKAAO_SANKTIONS_BIG[this.a]);
        this.h.setForeground(this.b);
        this.i.setForeground(this.b);
        this.changeSideLeft();
        this.add(this.n);
    }

    public void reset() {
        this.j = 0;
        this.k = 0;
        this.updateWarnings();
        this.updateFouls();
    }

    public void changeSide(boolean akaonright) {
        if (akaonright) {
            this.changeSideRight();
        } else {
            this.changeSideLeft();
        }
    }

    public void changeSideLeft() {
        this.n.removeAll();
        this.n.setLayout(new GridLayout(2, 2, 20, 2));
        this.d.setHorizontalAlignment(2);
        this.f.setHorizontalAlignment(2);
        this.e.setHorizontalAlignment(4);
        this.g.setHorizontalAlignment(4);
        this.h.setHorizontalAlignment(0);
        this.i.setHorizontalAlignment(0);
        if (!AnzeigePropertiesHelper.getPpusesimpledesign().equals("true") && !this.m) {
            this.n.setLayout(new GridLayout(1, 4, 20, 2));
            this.d.setText("WARNINGS");
            this.f.setText("FOULS");
            this.d.setHorizontalAlignment(4);
            this.f.setHorizontalAlignment(4);
            this.e.setHorizontalAlignment(2);
            this.g.setHorizontalAlignment(2);
            this.h.setHorizontalAlignment(0);
            this.i.setHorizontalAlignment(0);
        }
        this.n.add(this.d);
        this.n.add(this.e);
        this.n.add(this.f);
        this.n.add(this.g);
        this.n.revalidate();
        this.n.repaint();
    }

    public void changeSideRight() {
        this.n.removeAll();
        this.n.setLayout(new GridLayout(2, 2, 20, 2));
        this.d.setHorizontalAlignment(2);
        this.f.setHorizontalAlignment(2);
        this.e.setHorizontalAlignment(2);
        this.g.setHorizontalAlignment(2);
        this.h.setHorizontalAlignment(0);
        this.i.setHorizontalAlignment(0);
        this.n.add(this.e);
        this.n.add(this.d);
        this.n.add(this.g);
        this.n.add(this.f);
        this.n.revalidate();
        this.n.repaint();
    }

    public void updateWarnings() {
        if (this.j > 0) {
            this.e.setText("  " + this.j + "  ");
        } else {
            this.e.setText("  -  ");
        }
        this.e.repaint();
    }

    public void updateFouls() {
        if (this.k > 0) {
            this.g.setText("  " + this.k + "  ");
        } else {
            this.g.setText("  -  ");
        }
        this.g.repaint();
    }

    public void updateMinus(int minuscount) {
        if (minuscount > 0) {
            this.i.setText("  " + minuscount + "  ");
        } else {
            this.i.setText("  -  ");
        }
        this.i.repaint();
    }

    public void addWarning() {
        ++this.j;
        this.updateWarnings();
    }

    public void addFoul() {
        ++this.k;
        this.updateFouls();
    }

    public void removeWarning() {
        if (this.j > 0) {
            --this.j;
            this.updateWarnings();
        }
    }

    public void removeFoul() {
        if (this.k > 0) {
            --this.k;
            this.updateFouls();
        }
    }

    @Override
    public void update(int event, String message) {
        if (event == 128) {
            this.addWarning();
            if (this.m) {
                this.l.notifyListeners(136, "1 WARNINGS:" + this.j);
            }
            if (this.a != 0 && this.getWarningcount() > 0 && this.getWarningcount() % 3 == 0) {
                this.l.notifyListeners(4, "");
            }
        }
        if (event == 129) {
            this.removeWarning();
            if (this.m) {
                this.l.notifyListeners(137, "1 WARNINGS:" + this.j);
            }
            if (this.a != 0 && this.getWarningcount() > 0 && this.getWarningcount() % 3 == 2) {
                this.l.notifyListeners(152, "");
            }
        }
        if (event == 132) {
            this.addFoul();
            if (this.m) {
                this.l.notifyListeners(140, "1 FOULS:" + this.k);
            }
            if (this.a != 0 && this.getFoulcount() < 4) {
                this.l.notifyListeners(4, "");
            }
        }
        if (event == 133) {
            this.removeFoul();
            if (this.m) {
                this.l.notifyListeners(141, "1 FOULS:" + this.k);
            }
            if (this.a != 0 && this.getFoulcount() >= 0) {
                this.l.notifyListeners(152, "");
            }
        }
        if (event == 44) {
            this.reset();
        }
        if (event == 207) {
            try {
                this.updateMinus(Integer.parseInt(message));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (event == 145 && AnzeigePropertiesHelper.getPpitfteammode().equals("true")) {
            this.reset();
        }
    }

    public int getWarningcount() {
        return this.j;
    }

    public void setWarningcount(int warningcount) {
        this.j = warningcount;
    }

    public int getFoulcount() {
        return this.k;
    }

    public void setFoulcount(int foulcount) {
        this.k = foulcount;
    }
}

