/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppitf.anzeige.components;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sportdata.setppitf.anzeige.AnzeigeController;
import org.sportdata.setppitf.anzeige.circlejabel.JCircleLabelRoundedEdge;
import org.sportdata.setppitf.anzeige.components.TeamOverview;
import org.sportdata.setppitf.anzeige.constants.MainConstants;
import org.sportdata.setppitf.anzeige.interfaces.IAnzeigeEventListener;
import org.sportdata.setppitf.anzeige.properties.helper.AnzeigePropertiesHelper;

public class MatchRoundComponent
extends JPanel
implements IAnzeigeEventListener {
    private static final long serialVersionUID = -1295753154920288726L;
    private int d = 3;
    private ArrayList<Integer> e = new ArrayList();
    private ArrayList<Integer> f = new ArrayList();
    private ArrayList<Integer> g = new ArrayList();
    private AnzeigeController h;
    private boolean i;
    private JPanel j;
    private Color k;
    private boolean l = false;
    private JLabel m = new JLabel("R 1");
    JCircleLabelRoundedEdge a = new JCircleLabelRoundedEdge("");
    JCircleLabelRoundedEdge b = new JCircleLabelRoundedEdge("");
    JCircleLabelRoundedEdge c = new JCircleLabelRoundedEdge("");
    private TeamOverview n;

    public MatchRoundComponent(Color colorb, int mode, AnzeigeController acontrol, boolean logging, TeamOverview teamoverview) {
        this.d = mode;
        this.k = colorb;
        this.h = acontrol;
        this.i = logging;
        this.n = teamoverview;
        this.setOpaque(true);
        this.initComponent();
        this.updateRoundsAddLabelRound();
        this.registerPanel();
    }

    @Override
    public void registerPanel() {
        this.h.getListeners(this.d).add(this);
    }

    public void initComponent() {
        this.m.setFont(MainConstants.DISPLAY_FONT_MATCHES_ROUND[this.d]);
        if (AnzeigePropertiesHelper.getBackground().equals("black")) {
            this.m.setForeground(MainConstants.NAME_COLOR);
        } else {
            this.m.setForeground(MainConstants.NAME_COLOR_WHITE);
        }
        this.c.setOpaque(false);
        this.c.setBackground(Color.GRAY);
        this.c.setForeground(MainConstants.MATCHES_ROUND_COLOR);
        this.c.setFont(MainConstants.DISPLAY_FONT_MATCHES_ROUND[this.d]);
        this.a.setOpaque(false);
        this.a.setBackground(MainConstants.AKA_COLOR);
        this.a.setForeground(MainConstants.MATCHES_ROUND_COLOR);
        this.a.setFont(MainConstants.DISPLAY_FONT_MATCHES_ROUND[this.d]);
        this.b.setOpaque(false);
        this.b.setBackground(MainConstants.AO_COLOR);
        this.b.setForeground(MainConstants.MATCHES_ROUND_COLOR);
        this.b.setFont(MainConstants.DISPLAY_FONT_MATCHES_ROUND[this.d]);
        this.j = new JPanel();
        this.j.setBackground(this.k);
        this.add(this.j);
    }

    public void reset() {
        this.j.removeAll();
        this.g.clear();
        this.e.clear();
        this.f.clear();
        this.addRoundText();
        this.j.revalidate();
        this.j.repaint();
    }

    public void updateRounds() {
        this.j.removeAll();
        this.creatRounds();
        this.addRoundText();
        this.j.revalidate();
        this.j.repaint();
    }

    public void updateRoundsAddLabelRound() {
        this.j.removeAll();
        this.creatRounds();
        this.addRoundText();
        this.j.revalidate();
        this.j.repaint();
    }

    public int getActualRound() {
        return this.g.size() + 1;
    }

    public void addRoundText() {
        if (this.getNumberOfRounds() > 1) {
            this.updateRoundText();
            this.j.add(this.m);
        }
    }

    public void updateRoundText() {
        if (this.getActualRound() > this.getNumberOfRounds()) {
            this.m.setText("R " + this.getNumberOfRounds() + "/" + this.getNumberOfRounds());
        } else {
            this.m.setText("R " + this.getActualRound() + "/" + this.getNumberOfRounds());
        }
    }

    public void creatRounds() {
        if (AnzeigePropertiesHelper.getPpitfteammode().equals("true")) {
            if (this.e.size() > 0) {
                Vector<Vector<Integer>> umphiresVotes = new Vector<Vector<Integer>>();
                int i = 0;
                while (i < this.e.size()) {
                    Vector<Integer> uv = new Vector<Integer>();
                    uv.add(this.e.get(i));
                    if (!AnzeigePropertiesHelper.getPpitfteammodetradtional().equals("true")) {
                        if (this.e.get(i) + this.f.get(i) > 4) {
                            uv.add(0);
                        } else {
                            uv.add(4 - (this.e.get(i) + this.f.get(i)));
                        }
                    } else {
                        uv.add(0);
                    }
                    uv.add(this.f.get(i));
                    umphiresVotes.add(uv);
                    ++i;
                }
                this.n.addScores(umphiresVotes);
            } else {
                this.n.reset();
            }
        }
    }

    public void addRound(int winner, int akapoint, int aopoint) {
        this.g.add(winner);
        this.e.add(akapoint);
        this.f.add(aopoint);
    }

    public void removeLastRound() {
        if (this.g.size() > 0) {
            this.g.remove(this.g.size() - 1);
            this.e.remove(this.e.size() - 1);
            this.f.remove(this.f.size() - 1);
        }
    }

    @Override
    public void update(int event, String message) {
        if (event == 145) {
            this.updateRoundsAddLabelRound();
            if (this.i) {
                this.h.notifyListeners(146, "" + this.getActualRound());
            }
            if (this.i) {
                this.h.notifyListeners(169, "");
            }
        }
        if (event == 44) {
            this.reset();
            this.updateRoundsAddLabelRound();
            this.n.reset();
        }
        if (event == 151) {
            this.updateRoundText();
        }
        if (event == 111) {
            this.enchosenLastRound();
        }
    }

    public ArrayList<Integer> getAkapoints() {
        return this.e;
    }

    public void setAkapoints(ArrayList<Integer> akapoints) {
        this.e = akapoints;
    }

    public ArrayList<Integer> getAopoints() {
        return this.f;
    }

    public void setAopoints(ArrayList<Integer> aopoints) {
        this.f = aopoints;
    }

    public ArrayList<Integer> getRoundwinner() {
        return this.g;
    }

    public void setRoundwinner(ArrayList<Integer> roundwinner) {
        this.g = roundwinner;
    }

    public boolean isAkaonright() {
        return this.l;
    }

    public void setAkaonright(boolean akaonright) {
        this.l = akaonright;
    }

    public int getRoundsWonAka() {
        int akawins = 0;
        int i = 0;
        while (i < this.g.size()) {
            if (this.g.get(i) == 1) {
                ++akawins;
            }
            ++i;
        }
        return akawins;
    }

    public int getRoundsWonAo() {
        int aowins = 0;
        int i = 0;
        while (i < this.g.size()) {
            if (this.g.get(i) == 2) {
                ++aowins;
            }
            ++i;
        }
        return aowins;
    }

    public int getRoundsTie() {
        int aowins = 0;
        int i = 0;
        while (i < this.g.size()) {
            if (this.g.get(i) == 0) {
                ++aowins;
            }
            ++i;
        }
        return aowins;
    }

    public int getTotalPointsAka() {
        int akapointscount = 0;
        int i = 0;
        while (i < this.e.size()) {
            akapointscount += this.e.get(i).intValue();
            ++i;
        }
        return akapointscount;
    }

    public int getTotalPointsAo() {
        int aopointscount = 0;
        int i = 0;
        while (i < this.f.size()) {
            aopointscount += this.f.get(i).intValue();
            ++i;
        }
        return aopointscount;
    }

    public int getNumberOfRounds() {
        try {
            return Integer.parseInt(AnzeigePropertiesHelper.getPpnumberofrounds());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void enchosenLastRound() {
        while (this.getNumberOfRounds() > this.getActualRound()) {
            this.addRound(0, 0, 0);
        }
        this.updateRounds();
    }
}

