/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppitf.gamepad;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.sportdata.setppitf.anzeige.AnzeigeController;
import org.sportdata.setppitf.anzeige.interfaces.IAnzeigeEventListener;
import org.sportdata.setppitf.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setppitf.gamepad.GamePad;

public class GamePadLoader
implements IAnzeigeEventListener {
    private ArrayList<GamePad> a;
    private AnzeigeController b;
    private int c;

    public GamePadLoader(AnzeigeController acontrol, int mode) {
        this.b = acontrol;
        this.c = mode;
        this.a = new ArrayList();
        this.registerPanel();
    }

    public void searchForControllers() {
        try {
            if (this.a.size() > 0) {
                this.stopAllGamepads();
                this.removeAllControllers();
            }
            Controller[] controllers = GamePadLoader.a().getControllers();
            int i = 0;
            while (i < controllers.length) {
                Controller controller = controllers[i];
                if (controller.getType() == Controller.Type.STICK || controller.getType() == Controller.Type.GAMEPAD) {
                    this.a.add(new GamePad(controller, this.b, this.c, this.a.size()));
                }
                ++i;
            }
            this.startControllers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeAllControllers() {
        if (this.a.size() > 0) {
            int i = 0;
            while (i < this.a.size()) {
                this.a.get(i).unregisterPanel();
                ++i;
            }
            this.a.clear();
        }
    }

    private static ControllerEnvironment a() throws ReflectiveOperationException {
        Constructor<?> constructor = Class.forName("net.java.games.input.DefaultControllerEnvironment").getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        return (ControllerEnvironment)constructor.newInstance(new Object[0]);
    }

    public ArrayList<GamePad> getFoundControllers() {
        return this.a;
    }

    public void setFoundControllers(ArrayList<GamePad> foundControllers) {
        this.a = foundControllers;
    }

    public boolean allGamePadsAlive() {
        int i = 0;
        while (i < this.a.size()) {
            if (!this.a.get(i).canPoll()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void stopAllGamepads() {
        int i = 0;
        while (i < this.a.size()) {
            this.a.get(i).setKeeprunning(false);
            ++i;
        }
    }

    @Override
    public void registerPanel() {
        this.b.getListenersLast(this.c).add(this);
    }

    @Override
    public void update(int event, String message) {
        if (event == 195) {
            this.saveControllerConfig();
        }
    }

    public void startControllers() {
        int i = 0;
        while (i < this.getFoundControllers().size()) {
            this.getFoundControllers().get(i).startPoll();
            ++i;
        }
    }

    public boolean updateRefereeID(int index, int refereeid) {
        boolean isok = true;
        if (refereeid == 0) {
            try {
                this.getFoundControllers().get(index).setReferee(refereeid);
            }
            catch (Exception exception) {}
        } else {
            int i = 0;
            while (i < this.getFoundControllers().size()) {
                if (i != index && this.getFoundControllers().get(i).getReferee() == refereeid) {
                    isok = false;
                    break;
                }
                ++i;
            }
            if (isok) {
                try {
                    this.getFoundControllers().get(index).setReferee(refereeid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.saveControllerConfig();
        return isok;
    }

    public void saveControllerConfig() {
        Object refprops = "";
        int i = 0;
        while (i < this.getFoundControllers().size()) {
            if (i > 0) {
                refprops = (String)refprops + ";";
            }
            refprops = (String)refprops + this.getFoundControllers().get(i).getIndex() + "," + this.getFoundControllers().get(i).getController().getName() + "," + this.getFoundControllers().get(i).getReferee();
            refprops = this.getFoundControllers().get(i).getRedscorecomp() != null ? (String)refprops + "," + this.getFoundControllers().get(i).getRedscorecomp().getIdentifier().getName() : (String)refprops + ",";
            refprops = this.getFoundControllers().get(i).getBluescorecomp() != null ? (String)refprops + "," + this.getFoundControllers().get(i).getBluescorecomp().getIdentifier().getName() : (String)refprops + ",";
            ++i;
        }
        AnzeigePropertiesHelper.setPpgamepadconfig((String)refprops);
        AnzeigePropertiesHelper.saveAnzeigeProps();
    }

    public void loadRefereesFromProps() {
        if (!AnzeigePropertiesHelper.getPpgamepadconfig().trim().equals("")) {
            try {
                String[] refprops = AnzeigePropertiesHelper.getPpgamepadconfig().split(";");
                int i = 0;
                while (i < refprops.length) {
                    block16: {
                        String[] refprop = refprops[i].split(",");
                        if (i < this.getFoundControllers().size() && this.getFoundControllers().get(i).getController().getName().equals(refprop[1])) {
                            Component[] components;
                            block15: {
                                System.out.println("Fount controller name " + i + " " + refprop[1]);
                                try {
                                    int referee = Integer.parseInt(refprop[2]);
                                    this.getFoundControllers().get(i).setReferee(referee);
                                }
                                catch (Exception referee) {
                                    // empty catch block
                                }
                                components = this.getFoundControllers().get(i).getController().getComponents();
                                try {
                                    if (refprop.length < 4 || refprop[3].trim().equals("") || this.getFoundControllers().get(i).getRedscorecomp() != null) break block15;
                                    int j = 0;
                                    while (j < components.length) {
                                        if (components[j].getIdentifier().getName().equals(refprop[3])) {
                                            this.getFoundControllers().get(i).setRedscorecomp(components[j]);
                                            break;
                                        }
                                        ++j;
                                    }
                                }
                                catch (Exception j) {
                                    // empty catch block
                                }
                            }
                            try {
                                if (refprop.length < 5 || refprop[4].trim().equals("") || this.getFoundControllers().get(i).getBluescorecomp() != null) break block16;
                                int j = 0;
                                while (j < components.length) {
                                    if (components[j].getIdentifier().getName().equals(refprop[4])) {
                                        this.getFoundControllers().get(i).setBluescorecomp(components[j]);
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

