/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppitf.server.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sportdata.setppitf.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppitf.anzeige.beans.ScoringObject;
import org.sportdata.setppitf.anzeige.utils.DateUtils;

public class ScoringServlet
extends HttpServlet {
    public static final String SERVLET_URL = "scoring";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        response.getWriter().println("Scoring Request GET 200");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            String message = "";
            if (br != null) {
                message = br.readLine();
            }
            if (message != null && !message.trim().equals("") && message.indexOf("ScoreAction") > -1) {
                Gson gson = new Gson();
                JsonParser jsonParser = new JsonParser();
                String json = jsonParser.parse(message).getAsJsonObject().toString();
                ScoringObject obj = (ScoringObject)gson.fromJson(json, ScoringObject.class);
                if (json.indexOf("batterylevel") > -1) {
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(113, "batterylevel," + obj.getReferee() + "," + obj.getBatterylevel());
                }
                obj.printObject();
                boolean hasvalidscorer = false;
                if (obj.getScoreName().equals("point")) {
                    hasvalidscorer = true;
                    if (AnzeigeMaster.getInstance().hasAssignedImeiReferee(obj.getImei(), "" + obj.getReferee())) {
                        if (AnzeigeMaster.getInstance().getAnzeige().getClock().isRunningTrue() || DateUtils.isValidAppRequestByDateOfRunningClock(obj.getGenerated())) {
                            ScoringServlet.sendScore(obj);
                        } else if (AnzeigeMaster.getInstance().isDecisionmode()) {
                            ScoringServlet.sendScoreSingleScore(obj);
                        }
                        response.setContentType("text/html");
                        response.setStatus(200);
                        response.getWriter().println("Scoring request successfully processed");
                    } else {
                        response.setContentType("text/html");
                        response.setStatus(400);
                        response.getWriter().println("No assignment for imei and referee");
                    }
                }
                if (!hasvalidscorer) {
                    response.setContentType("text/html");
                    response.setStatus(400);
                    response.getWriter().println("Request Json not valid");
                }
            } else {
                response.setContentType("text/html");
                response.setStatus(400);
                response.getWriter().println("Request Json not valid");
            }
        }
        catch (Exception e) {
            try {
                response.setContentType("text/html");
                response.setStatus(400);
                response.getWriter().println("Error processing scoring");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void sendScore(ScoringObject obj) {
        int score;
        if (obj.getScorer().indexOf("RED") > -1) {
            score = Math.round(obj.getScoreValue());
            if (obj.getReferee() == 1) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(157, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 2) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(161, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 3) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(165, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 4) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(214, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
        }
        if (obj.getScorer().indexOf("BLUE") > -1) {
            score = Math.round(obj.getScoreValue());
            if (obj.getReferee() == 1) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(158, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 2) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(162, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 3) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(166, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 4) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(215, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
        }
    }

    public static void sendScoreSingleScore(ScoringObject obj) {
        int score;
        if (obj.getScorer().indexOf("RED") > -1) {
            score = 1;
            if (obj.getReferee() == 1) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(157, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 2) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(161, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 3) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(165, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 4) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(214, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
        }
        if (obj.getScorer().indexOf("BLUE") > -1) {
            score = 1;
            if (obj.getReferee() == 1) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(158, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 2) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(162, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 3) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(166, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 4) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(215, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
        }
    }
}

