/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VAttendee;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VDescribable2;
import jfxtras.icalendarfx.components.VDescribableBase;
import jfxtras.icalendarfx.components.VDuration;
import jfxtras.icalendarfx.properties.component.alarm.Action;
import jfxtras.icalendarfx.properties.component.alarm.RepeatCount;
import jfxtras.icalendarfx.properties.component.alarm.Trigger;
import jfxtras.icalendarfx.properties.component.descriptive.Description;
import jfxtras.icalendarfx.properties.component.relationship.Attendee;
import jfxtras.icalendarfx.properties.component.time.DurationProp;

public class VAlarm
extends VDescribableBase<VAlarm>
implements VDescribable2<VAlarm>,
VAttendee<VAlarm>,
VDuration<VAlarm> {
    private Action action;
    private List<Attendee> attendees;
    private Description description;
    private DurationProp duration;
    private RepeatCount repeatCount;
    private Trigger<?> trigger;

    public Action getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.setAction(Action.parse(action));
    }

    public void setAction(Action action) {
        this.orderer.replaceChild(this.action, action);
        this.action = action;
    }

    public void setAction(Action.ActionType action) {
        this.setAction(new Action(action));
    }

    public VAlarm withAction(Action action) {
        this.setAction(action);
        return this;
    }

    public VAlarm withAction(Action.ActionType actionType) {
        this.setAction(actionType);
        return this;
    }

    public VAlarm withAction(String action) {
        this.setAction(Action.parse(action));
        return this;
    }

    @Override
    public List<Attendee> getAttendees() {
        return this.attendees;
    }

    @Override
    public void setAttendees(List<Attendee> attendees) {
        if (this.attendees != null) {
            this.attendees.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.attendees = attendees;
        if (attendees != null) {
            attendees.forEach(c -> this.orderChild((VChild)c));
        }
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(Description description) {
        this.orderer.replaceChild(this.description, description);
        this.description = description;
    }

    @Override
    public DurationProp getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(DurationProp duration) {
        this.orderer.replaceChild(this.duration, duration);
        this.duration = duration;
    }

    public RepeatCount getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(RepeatCount repeatCount) {
        this.orderChild(this.repeatCount, (VChild)repeatCount);
        this.repeatCount = repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.setRepeatCount(new RepeatCount(repeatCount));
    }

    public void setRepeatCount(String repeatCount) {
        this.setRepeatCount(RepeatCount.parse(repeatCount));
    }

    public VAlarm withRepeatCount(RepeatCount repeatCount) {
        this.setRepeatCount(repeatCount);
        return this;
    }

    public VAlarm withRepeatCount(int repeatCount) {
        this.setRepeatCount(repeatCount);
        return this;
    }

    public VAlarm withRepeatCount(String repeatCount) {
        this.setRepeatCount(repeatCount);
        return this;
    }

    public Trigger<?> getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.setTrigger(Trigger.parse(trigger));
    }

    public void setTrigger(Trigger<?> trigger) {
        this.orderChild(this.trigger, trigger);
        this.trigger = trigger;
    }

    public void setTrigger(Duration trigger) {
        this.setTrigger(new Trigger<Duration>(trigger));
    }

    public void setTrigger(ZonedDateTime trigger) {
        this.setTrigger(new Trigger<ZonedDateTime>(trigger));
    }

    public VAlarm withTrigger(Trigger<?> trigger) {
        this.setTrigger(trigger);
        return this;
    }

    public VAlarm withTrigger(Duration trigger) {
        this.setTrigger(trigger);
        return this;
    }

    public VAlarm withTrigger(ZonedDateTime trigger) {
        this.setTrigger(trigger);
        return this;
    }

    public VAlarm withTrigger(String trigger) {
        this.setTrigger(trigger);
        return this;
    }

    public VAlarm() {
    }

    public VAlarm(VAlarm source) {
        super(source);
    }

    @Override
    public List<String> errors() {
        boolean isRepeatNull;
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getAction() == null) {
            errors.add("ACTION is not present.  ACTION is REQUIRED and MUST NOT occur more than once");
        }
        if (this.getTrigger() == null) {
            errors.add("TRIGGER is not present.  TRIGGER is REQUIRED and MUST NOT occur more than once");
        }
        boolean isDurationNull = this.getDuration() == null;
        boolean bl = isRepeatNull = this.getRepeatCount() == null;
        if (isDurationNull && !isRepeatNull) {
            errors.add("DURATION is present but REPEAT is not present.  DURATION and REPEAT are both OPTIONAL, and MUST NOT occur more than once each, but if one occurs, so MUST the other.");
        }
        if (!isDurationNull && isRepeatNull) {
            errors.add("REPEAT is present but DURATION is not present.  DURATION and REPEAT are both OPTIONAL, and MUST NOT occur more than once each, but if one occurs, so MUST the other.");
        }
        return Collections.unmodifiableList(errors);
    }

    @Override
    public List<? extends VComponent> calendarList() {
        throw new RuntimeException("VAlarm " + this.name() + " is embedded in VEVENT or VTODO not VCalendar");
    }

    public static VAlarm parse(String content) {
        return VAlarm.parse(new VAlarm(), content);
    }
}

