/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VElement;
import jfxtras.icalendarfx.components.DaylightSavingTime;
import jfxtras.icalendarfx.components.StandardTime;
import jfxtras.icalendarfx.components.VAlarm;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VEvent;
import jfxtras.icalendarfx.components.VFreeBusy;
import jfxtras.icalendarfx.components.VJournal;
import jfxtras.icalendarfx.components.VTimeZone;
import jfxtras.icalendarfx.components.VTodo;

public enum VComponentElement {
    VEVENT("VEVENT", VEvent.class),
    VTODO("VTODO", VTodo.class),
    VJOURNAL("VJOURNAL", VJournal.class),
    VTIMEZONE("VTIMEZONE", VTimeZone.class),
    VFREEBUSY("VFREEBUSY", VFreeBusy.class),
    DAYLIGHT_SAVING_TIME("DAYLIGHT", DaylightSavingTime.class),
    STANDARD_TIME("STANDARD", StandardTime.class),
    VALARM("VALARM", VAlarm.class);

    private static final Map<String, VComponentElement> NAME_MAP;
    private static final Map<Class<? extends VComponent>, VComponentElement> CLASS_MAP;
    private Class<? extends VComponent> myClass;
    private String name;

    public static VComponentElement fromName(String propertyName) {
        return NAME_MAP.get(propertyName.toUpperCase());
    }

    public static VComponentElement fromClass(Class<? extends VElement> myClass) {
        VComponentElement p = CLASS_MAP.get(myClass);
        if (p == null) {
            throw new IllegalArgumentException(VComponentElement.class.getSimpleName() + " does not contain an enum to match the class:" + myClass.getSimpleName());
        }
        return p;
    }

    public Class<? extends VComponent> elementClass() {
        return this.myClass;
    }

    public String toString() {
        return this.name;
    }

    private VComponentElement(String name, Class<? extends VComponent> myClass) {
        this.name = name;
        this.myClass = myClass;
    }

    static {
        NAME_MAP = Arrays.stream(VComponentElement.values()).collect(Collectors.toMap(v -> v.toString(), v -> v));
        CLASS_MAP = Arrays.stream(VComponentElement.values()).collect(Collectors.toMap(v -> v.elementClass(), v -> v));
    }
}

