/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.properties.component.time.DateTimeEnd;
import jfxtras.icalendarfx.properties.component.time.DateTimeStart;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public interface VDateTimeEnd<T>
extends VComponent {
    public DateTimeEnd getDateTimeEnd();

    public void setDateTimeEnd(DateTimeEnd var1);

    default public void setDateTimeEnd(String dtEnd) {
        this.setDateTimeEnd(DateTimeEnd.parse(dtEnd));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void setDateTimeEnd(Temporal temporal) {
        if (this.getDateTimeEnd() == null || !((Temporal)this.getDateTimeEnd().getValue()).getClass().equals(temporal.getClass())) {
            boolean t1 = temporal instanceof LocalDate;
            boolean t2 = temporal instanceof LocalDateTime;
            boolean t3 = temporal instanceof ZonedDateTime;
            if (!t1 && !t2 && !t3) throw new DateTimeException("Only LocalDate, LocalDateTime and ZonedDateTime supported. " + temporal.getClass().getSimpleName() + " is not supported");
            this.setDateTimeEnd(new DateTimeEnd(temporal));
            return;
        } else {
            this.setDateTimeEnd(new DateTimeEnd(temporal));
        }
    }

    default public T withDateTimeEnd(Temporal dtEnd) {
        this.setDateTimeEnd(dtEnd);
        return (T)this;
    }

    default public T withDateTimeEnd(String dtEnd) {
        this.setDateTimeEnd(dtEnd);
        return (T)this;
    }

    default public T withDateTimeEnd(DateTimeEnd dtEnd) {
        this.setDateTimeEnd(dtEnd);
        return (T)this;
    }

    public DateTimeStart getDateTimeStart();

    default public void checkDateTimeEndConsistency() {
        List<String> errors = VDateTimeEnd.errorsDateTimeEnd(this);
        if (!errors.isEmpty()) {
            String message = errors.stream().collect(Collectors.joining(System.lineSeparator()));
            throw new DateTimeException(message);
        }
    }

    public static List<String> errorsDateTimeEnd(VDateTimeEnd<?> testObj) {
        ArrayList<String> errors = new ArrayList<String>();
        if (testObj.getDateTimeEnd() != null && testObj.getDateTimeStart() != null) {
            int after;
            DateTimeUtilities.DateTimeType dateTimeEndType;
            boolean isDateTimeEndMatch;
            DateTimeUtilities.DateTimeType dateTimeStartType = DateTimeUtilities.DateTimeType.of((Temporal)testObj.getDateTimeStart().getValue());
            boolean bl = isDateTimeEndMatch = dateTimeStartType == (dateTimeEndType = DateTimeUtilities.DateTimeType.of((Temporal)testObj.getDateTimeEnd().getValue()));
            if (!isDateTimeEndMatch) {
                errors.add("DTEND value type (" + dateTimeEndType + ") must be the same value type as DTSTART (" + dateTimeStartType + ")");
            }
            if ((after = DateTimeUtilities.TEMPORAL_COMPARATOR2.compare((Temporal)testObj.getDateTimeEnd().getValue(), (Temporal)testObj.getDateTimeStart().getValue())) == -1) {
                errors.add("DTEND does not occur after DTSTART.  DTEND MUST occur after DTSTART (" + testObj.getDateTimeEnd().getValue() + ", " + testObj.getDateTimeStart().getValue() + ")");
            }
        }
        return errors;
    }
}

