/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.time.Duration;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.List;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VDateTimeEnd;
import jfxtras.icalendarfx.components.VDescribable2;
import jfxtras.icalendarfx.components.VLocatable;
import jfxtras.icalendarfx.components.VRepeatable;
import jfxtras.icalendarfx.properties.component.time.DateTimeEnd;
import jfxtras.icalendarfx.properties.component.time.TimeTransparency;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public class VEvent
extends VLocatable<VEvent>
implements VDateTimeEnd<VEvent>,
VDescribable2<VEvent>,
VRepeatable<VEvent> {
    private DateTimeEnd dateTimeEnd;
    private TimeTransparency timeTransparency;

    @Override
    public DateTimeEnd getDateTimeEnd() {
        return this.dateTimeEnd;
    }

    @Override
    public void setDateTimeEnd(DateTimeEnd dateTimeEnd) {
        this.orderChild(this.dateTimeEnd, (VChild)dateTimeEnd);
        this.dateTimeEnd = dateTimeEnd;
    }

    public TimeTransparency getTimeTransparency() {
        return this.timeTransparency;
    }

    public void setTimeTransparency(String timeTransparency) {
        this.setTimeTransparency(TimeTransparency.parse(timeTransparency));
    }

    public void setTimeTransparency(TimeTransparency timeTransparency) {
        this.orderChild(this.timeTransparency, (VChild)timeTransparency);
        this.timeTransparency = timeTransparency;
    }

    public void setTimeTransparency(TimeTransparency.TimeTransparencyType timeTransparency) {
        this.setTimeTransparency(new TimeTransparency(timeTransparency));
    }

    public VEvent withTimeTransparency(TimeTransparency timeTransparency) {
        this.setTimeTransparency(timeTransparency);
        return this;
    }

    public VEvent withTimeTransparency(TimeTransparency.TimeTransparencyType timeTransparencyType) {
        this.setTimeTransparency(timeTransparencyType);
        return this;
    }

    public VEvent withTimeTransparency(String timeTransparency) {
        this.setTimeTransparency(TimeTransparency.parse(timeTransparency));
        return this;
    }

    public VEvent() {
    }

    public VEvent(VEvent source) {
        super(source);
    }

    @Override
    public TemporalAmount getActualDuration() {
        TemporalAmount duration;
        if (this.getDuration() != null) {
            duration = (TemporalAmount)this.getDuration().getValue();
        } else if (this.getDateTimeEnd() != null) {
            Temporal dtstart = (Temporal)this.getDateTimeStart().getValue();
            Temporal dtend = (Temporal)this.getDateTimeEnd().getValue();
            duration = DateTimeUtilities.temporalAmountBetween(dtstart, dtend);
        } else {
            return Duration.ZERO;
        }
        return duration;
    }

    @Override
    public void setEndOrDuration(Temporal startRecurrence, Temporal endRecurrence) {
        TemporalAmount duration = DateTimeUtilities.temporalAmountBetween(startRecurrence, endRecurrence);
        if (this.getDuration() != null) {
            this.setDuration(duration);
        } else if (this.getDateTimeEnd() != null) {
            Temporal dtend = ((Temporal)this.getDateTimeStart().getValue()).plus(duration);
            this.setDateTimeEnd(dtend);
        } else {
            throw new RuntimeException("Either DTEND or DURATION must be set");
        }
    }

    @Override
    public List<String> errors() {
        boolean isDurationPresent;
        List<String> errors = super.errors();
        List<String> dtendError = VDateTimeEnd.errorsDateTimeEnd(this);
        errors.addAll(dtendError);
        if (this.getDateTimeStart() == null) {
            errors.add("DTSTART is not present.  DTSTART is REQUIRED and MUST NOT occur more than once");
        }
        boolean isDateTimeEndPresent = this.getDateTimeEnd() != null;
        boolean bl = isDurationPresent = this.getDuration() != null;
        if ((isDateTimeEndPresent || isDurationPresent) && isDateTimeEndPresent && isDurationPresent) {
            errors.add("Both DTEND and DURATION are present.  DTEND or DURATION MAY exist, but both MUST NOT occur in the same " + this.name());
        }
        return Collections.unmodifiableList(errors);
    }

    public List<VEvent> calendarList() {
        if (this.getParent() != null) {
            VCalendar cal = (VCalendar)this.getParent();
            return cal.getVEvents();
        }
        throw new RuntimeException("Parent isn't set");
    }

    @Override
    @Deprecated
    public void eraseDateTimeProperties() {
        super.eraseDateTimeProperties();
        this.setDateTimeEnd((DateTimeEnd)null);
    }

    public static VEvent parse(String content) {
        return VEvent.parse(new VEvent(), content);
    }
}

