/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.DaylightSavingTime;
import jfxtras.icalendarfx.components.StandardOrDaylight;
import jfxtras.icalendarfx.components.StandardTime;
import jfxtras.icalendarfx.components.VCommon;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VComponentElement;
import jfxtras.icalendarfx.components.VLastModified;
import jfxtras.icalendarfx.properties.component.change.LastModified;
import jfxtras.icalendarfx.properties.component.timezone.TimeZoneIdentifier;
import jfxtras.icalendarfx.properties.component.timezone.TimeZoneURL;

public class VTimeZone
extends VCommon<VTimeZone>
implements VLastModified<VTimeZone> {
    private List<StandardOrDaylight<?>> standardOrDaylight;
    private LastModified lastModified;
    private TimeZoneIdentifier timeZoneIdentifier;
    private TimeZoneURL timeZoneURL;

    public List<StandardOrDaylight<?>> getStandardOrDaylight() {
        return this.standardOrDaylight;
    }

    public void setStandardOrDaylight(List<StandardOrDaylight<?>> standardOrDaylight) {
        if (this.standardOrDaylight != null) {
            this.standardOrDaylight.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.standardOrDaylight = standardOrDaylight;
        if (standardOrDaylight != null) {
            standardOrDaylight.forEach(c -> this.orderChild((VChild)c));
        }
    }

    public VTimeZone withStandardOrDaylight(List<StandardOrDaylight<?>> standardOrDaylight) {
        if (this.getStandardOrDaylight() == null) {
            this.setStandardOrDaylight(new ArrayList());
        }
        this.getStandardOrDaylight().addAll(standardOrDaylight);
        if (standardOrDaylight != null) {
            standardOrDaylight.forEach(c -> this.orderChild((VChild)c));
        }
        return this;
    }

    public VTimeZone withStandardOrDaylight(StandardOrDaylight<?> ... standardOrDaylight) {
        return this.withStandardOrDaylight(Arrays.asList(standardOrDaylight));
    }

    public VTimeZone withStandardOrDaylight(String ... standardOrDaylight) {
        List<StandardOrDaylight<?>> newElements = Arrays.stream(standardOrDaylight).map(c -> {
            StandardOrDaylight v;
            if (c.startsWith("BEGIN:" + VComponentElement.DAYLIGHT_SAVING_TIME.toString())) {
                v = DaylightSavingTime.parse(c);
            } else if (c.startsWith("BEGIN:" + VComponentElement.STANDARD_TIME.toString())) {
                v = StandardTime.parse(c);
            } else {
                throw new IllegalArgumentException("Invalid calendar content text.  Must start with BEGIN:DAYLIGHT or BEGIN:STANDARD");
            }
            v.addChild((String)c);
            return v;
        }).collect(Collectors.toList());
        return this.withStandardOrDaylight(newElements);
    }

    @Override
    public LastModified getDateTimeLastModified() {
        return this.lastModified;
    }

    @Override
    public void setDateTimeLastModified(LastModified lastModified) {
        this.orderChild(this.lastModified, (VChild)lastModified);
        this.lastModified = lastModified;
    }

    public TimeZoneIdentifier getTimeZoneIdentifier() {
        return this.timeZoneIdentifier;
    }

    public void setTimeZoneIdentifier(TimeZoneIdentifier timeZoneIdentifier) {
        this.orderChild(this.timeZoneIdentifier, (VChild)timeZoneIdentifier);
        this.timeZoneIdentifier = timeZoneIdentifier;
    }

    public void setTimeZoneIdentifier(String timeZoneIdentifier) {
        this.setTimeZoneIdentifier(TimeZoneIdentifier.parse(timeZoneIdentifier));
    }

    public VTimeZone withTimeZoneIdentifier(TimeZoneIdentifier timeZoneIdentifier) {
        this.setTimeZoneIdentifier(timeZoneIdentifier);
        return this;
    }

    public VTimeZone withTimeZoneIdentifier(String timeZoneIdentifier) {
        this.setTimeZoneIdentifier(timeZoneIdentifier);
        return this;
    }

    public TimeZoneURL getTimeZoneURL() {
        return this.timeZoneURL;
    }

    public void setTimeZoneURL(TimeZoneURL timeZoneURL) {
        this.orderChild(this.timeZoneURL, (VChild)timeZoneURL);
        this.timeZoneURL = timeZoneURL;
    }

    public void setTimeZoneURL(String timeZoneURL) {
        this.setTimeZoneURL(TimeZoneURL.parse(timeZoneURL));
    }

    public void setTimeZoneURL(URI timeZoneURL) {
        this.setTimeZoneURL(new TimeZoneURL(timeZoneURL));
    }

    public VTimeZone withTimeZoneURL(TimeZoneURL timeZoneURL) {
        this.setTimeZoneURL(timeZoneURL);
        return this;
    }

    public VTimeZone withTimeZoneURL(URI timeZoneURL) {
        this.setTimeZoneURL(new TimeZoneURL(timeZoneURL));
        return this;
    }

    public VTimeZone withTimeZoneURL(String timeZoneURL) {
        this.setTimeZoneURL(timeZoneURL);
        return this;
    }

    public VTimeZone() {
    }

    public VTimeZone(VTimeZone source) {
        super(source);
    }

    @Override
    protected Method getSetter(VChild child) {
        Method setter = this.getSetters().get(child.getClass());
        if (setter == null && StandardOrDaylight.class.isAssignableFrom(child.getClass())) {
            setter = this.getSetters().get(StandardOrDaylight.class);
        }
        return setter;
    }

    @Override
    protected Method getGetter(VChild child) {
        Method getter = this.getGetters().get(child.getClass());
        if (getter == null && StandardOrDaylight.class.isAssignableFrom(child.getClass())) {
            getter = this.getGetters().get(StandardOrDaylight.class);
        }
        return getter;
    }

    @Override
    public List<String> errors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getTimeZoneIdentifier() == null) {
            errors.add("TZID is REQUIRED and MUST NOT occur more than once");
        }
        if (this.getStandardOrDaylight() != null && this.getStandardOrDaylight().size() > 0) {
            this.getStandardOrDaylight().forEach(c -> errors.addAll(c.errors()));
        } else {
            errors.add("No STANDARD or DAYLIGHT subcomponents exist.  At least one STANDARD or DAYLIGHT subcomponent MUST occur");
        }
        return Collections.unmodifiableList(errors);
    }

    @Override
    void addSubcomponent(VComponent subcomponent) {
        List<StandardOrDaylight<?>> list;
        if (subcomponent instanceof StandardOrDaylight) {
            if (this.getStandardOrDaylight() == null) {
                list = new ArrayList();
                this.setStandardOrDaylight(list);
            } else {
                list = this.getStandardOrDaylight();
            }
        } else {
            throw new IllegalArgumentException("Unsuported subcomponent type:" + subcomponent.getClass().getSimpleName() + " found inside " + this.name() + " component");
        }
        list.add((StandardOrDaylight)subcomponent);
    }

    public List<VTimeZone> calendarList() {
        if (this.getParent() != null) {
            VCalendar cal = (VCalendar)this.getParent();
            return cal.getVTimeZones();
        }
        return null;
    }

    public static VTimeZone parse(String content) {
        return VTimeZone.parse(new VTimeZone(), content);
    }
}

