/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.content;

import java.util.stream.Collectors;
import jfxtras.icalendarfx.content.ContentLineBase;
import jfxtras.icalendarfx.content.Orderer;

public class MultiLineContent
extends ContentLineBase {
    private final String firstContentLine;
    private final String lastContentLine;
    private final int builderSize;

    public MultiLineContent(Orderer orderer, String firstContentLine, String lastContentLine, int builderSize) {
        super(orderer);
        this.firstContentLine = firstContentLine;
        this.lastContentLine = lastContentLine;
        this.builderSize = builderSize;
    }

    @Override
    public String execute() {
        StringBuilder builder = new StringBuilder(this.builderSize);
        builder.append(this.firstContentLine + System.lineSeparator());
        String content = this.orderer.childrenUnmodifiable().stream().map(c -> c.toString()).collect(Collectors.joining(System.lineSeparator()));
        if (!content.isEmpty()) {
            builder.append(content + System.lineSeparator());
        }
        builder.append(this.lastContentLine);
        return builder.toString();
    }
}

