/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.content;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.VParent;
import jfxtras.icalendarfx.content.Orderer;

public class OrdererBase
implements Orderer {
    private final VParent parent;
    private final Map<Class<? extends VChild>, Method> childGetters;
    private List<VChild> orderedChildren = new ArrayList<VChild>();

    public OrdererBase(VParent aParent, Map<Class<? extends VChild>, Method> map) {
        this.parent = aParent;
        this.childGetters = map;
    }

    @Override
    public List<VChild> childrenUnmodifiable() {
        return this.orderedChildren;
    }

    private List<VChild> allUnorderedChildren(VParent parent, Map<Class<? extends VChild>, Method> childGetters2) {
        return Collections.unmodifiableList(childGetters2.entrySet().stream().map(e -> (Method)e.getValue()).map(m -> {
            try {
                return m.invoke((Object)parent, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(p -> p != null).flatMap(p -> {
            if (Collection.class.isAssignableFrom(p.getClass())) {
                return ((Collection)p).stream();
            }
            return Arrays.stream(new VChild[]{(VChild)p});
        }).collect(Collectors.toList()));
    }

    @Override
    public void orderChild(VChild newChild) {
        if (newChild == this.parent) {
            throw new RuntimeException("Can't add you to yourself!");
        }
        this.orderedChildren.add(newChild);
        newChild.setParent(this.parent);
    }

    private void removeOrphans(VChild newChild) {
        List<VChild> allUnorderedChildren = this.allUnorderedChildren(this.parent, this.childGetters);
        List<VChild> orphans = this.orderedChildren.stream().filter(c -> c.getClass().equals(newChild.getClass())).filter(c -> !allUnorderedChildren.contains(c)).collect(Collectors.toList());
        orphans.forEach(c -> this.orderedChildren.remove(c));
    }

    @Override
    public void orderChild(int index, VChild newChild) {
        if (newChild != null) {
            this.orderedChildren.remove(newChild);
            this.orderedChildren.add(index, newChild);
            newChild.setParent(this.parent);
        }
    }

    @Override
    public boolean replaceChild(VChild oldChild, VChild newChild) {
        if (newChild == null) {
            if (oldChild != null) {
                return this.orderedChildren.remove(oldChild);
            }
        } else if (oldChild == null) {
            this.orderChild(newChild);
        } else {
            int index = this.orderedChildren.indexOf(oldChild);
            VChild result = this.orderedChildren.set(index, newChild);
            return result.equals(oldChild);
        }
        return false;
    }

    public String toString() {
        return "OrdererBase [parent=" + this.parent + ", orderedChildren=" + this.orderedChildren + "]";
    }
}

