/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.itip;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.components.VTimeZone;
import jfxtras.icalendarfx.itip.Processable;
import jfxtras.icalendarfx.properties.component.relationship.UniqueIdentifier;

public class ProcessPublish
implements Processable {
    @Override
    public List<String> process(VCalendar mainVCalendar, VCalendar iTIPMessage) {
        ArrayList<String> log = new ArrayList<String>();
        iTIPMessage.childrenUnmodifiable().stream().filter(c -> c instanceof VComponent).map(c -> (VComponent)c).forEach(c -> {
            if (c instanceof VDisplayable) {
                VDisplayable oldMatchingVComponent;
                Temporal recurrenceID;
                boolean hasNoAttendees;
                boolean hasOrganizer;
                VDisplayable vDisplayable = (VDisplayable)c;
                boolean bl = hasOrganizer = vDisplayable.getOrganizer() != null;
                if (!hasOrganizer) {
                    log.add("WARNING: According to RFC 5546, a PUBLISH method MUST contain the ORGANIZER property and it's absent. " + c.getClass().getSimpleName() + " with UID:" + (String)vDisplayable.getUniqueIdentifier().getValue() + " is being processed anyway.");
                }
                boolean bl2 = hasNoAttendees = vDisplayable.getAttendees() == null;
                if (!hasNoAttendees) {
                    log.add("WARNING: According to RFC 5546, a PUBLISH MUST NOT contain the ATTENDEE property yet it's exists. " + c.getClass().getSimpleName() + " with UID:" + (String)vDisplayable.getUniqueIdentifier().getValue() + " is being processed anyway.");
                }
                int newSequence = vDisplayable.getSequence() == null ? 0 : (Integer)vDisplayable.getSequence().getValue();
                boolean isNewSequenceHigher = true;
                UniqueIdentifier uid = vDisplayable.getUniqueIdentifier();
                List<? extends VComponent> list = mainVCalendar.getVComponents(vDisplayable);
                List relatedVComponents = list == null ? null : mainVCalendar.getVComponents(vDisplayable).stream().filter(v -> v instanceof VDisplayable).map(v -> (VDisplayable)v).filter(v -> v.getUniqueIdentifier().equals(uid)).collect(Collectors.toList());
                Temporal temporal = recurrenceID = vDisplayable.getRecurrenceId() != null ? (Temporal)vDisplayable.getRecurrenceId().getValue() : null;
                if (relatedVComponents != null && (oldMatchingVComponent = relatedVComponents.stream().filter(v -> {
                    Temporal mRecurrenceID = v.getRecurrenceId() != null ? (Temporal)v.getRecurrenceId().getValue() : null;
                    return Objects.equals(recurrenceID, mRecurrenceID);
                }).findAny().orElseGet(() -> null)) != null) {
                    int oldSequence = oldMatchingVComponent.getSequence() == null ? 0 : (Integer)oldMatchingVComponent.getSequence().getValue();
                    boolean bl3 = isNewSequenceHigher = newSequence > oldSequence || newSequence == 0 && oldSequence == 0;
                    if (!isNewSequenceHigher) {
                        throw new IllegalArgumentException("Can't process PUBLISH method: SEQUENCY property MUST be higher than previously published component (new=" + newSequence + " old=" + oldSequence + ")");
                    }
                    if (isNewSequenceHigher) {
                        mainVCalendar.removeChild(oldMatchingVComponent);
                    }
                }
                mainVCalendar.addChild((VChild)c);
                log.add("SUCCESS: added " + c.getClass().getSimpleName() + " with UID:" + (String)vDisplayable.getUniqueIdentifier().getValue());
                List<VDisplayable<?>> orphanedChildren = vDisplayable.orphanedRecurrenceChildren();
                if (!orphanedChildren.isEmpty()) {
                    vDisplayable.calendarList().removeAll(orphanedChildren);
                }
            } else if (c instanceof VTimeZone) {
                mainVCalendar.getVTimeZones().add((VTimeZone)c);
            } else {
                log.add("Can't process non-displayble component method (not implemented):" + System.lineSeparator() + c.toString());
            }
        });
        return log;
    }
}

