/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.parameters;

import jfxtras.icalendarfx.parameters.VParameterBase;
import jfxtras.icalendarfx.utilities.StringConverter;
import jfxtras.icalendarfx.utilities.StringConverters;

public class FormatType
extends VParameterBase<FormatType, String> {
    private static final StringConverter<String> CONVERTER = StringConverters.defaultStringConverterWithQuotes();
    private String typeName;
    private String subtypeName;

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
        this.buildNewValue();
    }

    public String getSubtypeName() {
        return this.subtypeName;
    }

    public void setSubtypeName(String subtypeName) {
        this.subtypeName = subtypeName;
        this.buildNewValue();
    }

    @Override
    public void setValue(String value) {
        int slashIndex = value.indexOf(47);
        if (slashIndex <= 0) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires both type-name / subtype-name as defined in RFC4288");
        }
        this.setTypeName(value.substring(0, slashIndex));
        this.setSubtypeName(value.substring(slashIndex + 1));
        super.setValue(value);
    }

    private void buildNewValue() {
        if (this.getTypeName() != null && this.getSubtypeName() != null) {
            String newValue = this.getTypeName() + "/" + this.getSubtypeName();
            super.setValue(newValue);
        }
    }

    public FormatType() {
        super(CONVERTER);
    }

    public FormatType(FormatType source) {
        super(source, CONVERTER);
    }

    public static FormatType parse(String content) {
        return FormatType.parse(new FormatType(), content);
    }
}

