/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.parameters;

import java.util.HashMap;
import java.util.Map;
import jfxtras.icalendarfx.parameters.VParameterBase;
import jfxtras.icalendarfx.utilities.StringConverter;

public class Range
extends VParameterBase<Range, RangeType> {
    private static final StringConverter<RangeType> CONVERTER = new StringConverter<RangeType>(){

        @Override
        public String toString(RangeType object) {
            return object.toString();
        }

        @Override
        public RangeType fromString(String string) {
            return RangeType.enumFromName(string.toUpperCase());
        }
    };

    public Range() {
        super(RangeType.THIS_AND_FUTURE, CONVERTER);
    }

    public Range(RangeType value) {
        super(value, CONVERTER);
    }

    public Range(String content) {
        super(RangeType.enumFromName(content), CONVERTER);
    }

    public Range(Range source) {
        super(source, CONVERTER);
    }

    public static Range parse(String content) {
        return Range.parse(new Range(), content);
    }

    public static enum RangeType {
        THIS_AND_FUTURE("THISANDFUTURE"),
        THIS_AND_PRIOR("THISANDPRIOR");

        private static Map<String, RangeType> enumFromNameMap;
        private String name;

        private static Map<String, RangeType> makeEnumFromNameMap() {
            HashMap<String, RangeType> map = new HashMap<String, RangeType>();
            RangeType[] values = RangeType.values();
            for (int i = 0; i < values.length; ++i) {
                map.put(values[i].toString(), values[i]);
            }
            return map;
        }

        public static RangeType enumFromName(String propertyName) {
            return enumFromNameMap.get(propertyName.toUpperCase());
        }

        public String toString() {
            return this.name;
        }

        private RangeType(String name) {
            this.name = name;
        }

        static {
            enumFromNameMap = RangeType.makeEnumFromNameMap();
        }
    }
}

