/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.misc;

import java.text.DecimalFormat;
import jfxtras.icalendarfx.properties.PropBaseLanguage;

public class RequestStatus
extends PropBaseLanguage<String, RequestStatus> {
    private Double statusCode;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.0#");
    private String description;
    private String exception;

    public Double getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Double statusCode) {
        this.statusCode = statusCode;
        this.updateValue();
    }

    public RequestStatus withStatusCode(Double statusCode) {
        this.setStatusCode(statusCode);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateValue();
    }

    public RequestStatus withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public RequestStatus withException(String exception) {
        this.setException(exception);
        return this;
    }

    public RequestStatus(RequestStatus source) {
        super(source);
    }

    public RequestStatus() {
    }

    @Override
    protected String valueContent() {
        StringBuilder builder = new StringBuilder(100);
        builder.append(DECIMAL_FORMAT.format(this.getStatusCode()) + ";");
        builder.append(this.getConverter().toString(this.getDescription()));
        if (this.getException() != null) {
            builder.append(";" + this.getConverter().toString(this.getException()));
        }
        return builder.toString();
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        int codeIndex = value.indexOf(59);
        this.setStatusCode(Double.parseDouble(value.substring(0, codeIndex)));
        int descriptionIndex = value.indexOf(59, codeIndex + 1);
        if (descriptionIndex > 0) {
            this.setDescription(value.substring(codeIndex + 1, descriptionIndex));
            this.setException(value.substring(descriptionIndex + 1));
        } else {
            this.setDescription(value.substring(codeIndex + 1));
        }
    }

    private void updateValue() {
        StringBuilder builder = new StringBuilder(100);
        builder.append(DECIMAL_FORMAT.format(this.getStatusCode()) + ";");
        builder.append(this.getDescription());
        if (this.getException() != null) {
            builder.append(";" + this.getException());
        }
        super.setValue(builder.toString());
    }

    public static RequestStatus parse(String content) {
        return RequestStatus.parse(new RequestStatus(), content);
    }
}

