/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.properties.PropBaseDateTime;
import jfxtras.icalendarfx.properties.ValueType;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.icalendarfx.utilities.StringConverter;

public abstract class PropertyBaseRecurrence<U>
extends PropBaseDateTime<Set<Temporal>, U> {
    private final StringConverter<Set<Temporal>> CONVERTER = new StringConverter<Set<Temporal>>(){

        @Override
        public String toString(Set<Temporal> object) {
            return object.stream().sorted(DateTimeUtilities.TEMPORAL_COMPARATOR).map(t -> DateTimeUtilities.temporalToString(t)).collect(Collectors.joining(","));
        }

        @Override
        public Set<Temporal> fromString(String string) {
            Set<Temporal> set = Arrays.stream(string.split(",")).map(s -> DateTimeUtilities.temporalFromString(s)).collect(Collectors.toSet());
            TreeSet<Temporal> treeSet = new TreeSet<Temporal>(DateTimeUtilities.TEMPORAL_COMPARATOR);
            treeSet.addAll(set);
            return set;
        }
    };

    public PropertyBaseRecurrence(Set<Temporal> value) {
        this();
        this.setValue(value);
        if (!this.isValid()) {
            throw new IllegalArgumentException("Error in parsing " + value);
        }
    }

    public PropertyBaseRecurrence(Temporal ... temporals) {
        this();
        TreeSet<Temporal> tree = new TreeSet<Temporal>(DateTimeUtilities.TEMPORAL_COMPARATOR);
        tree.addAll(Arrays.asList(temporals));
        this.setValue((Set<Temporal>)tree);
        if (!this.isValid()) {
            throw new IllegalArgumentException("Error in parsing " + temporals);
        }
    }

    public PropertyBaseRecurrence() {
        super(new TreeSet<Temporal>(DateTimeUtilities.TEMPORAL_COMPARATOR));
        this.setConverter(this.CONVERTER);
    }

    public PropertyBaseRecurrence(PropertyBaseRecurrence<U> source) {
        super(source);
    }

    @Override
    public void setValue(Set<Temporal> value) {
        if (!value.isEmpty()) {
            Temporal sampleValue = value.iterator().next();
            if (sampleValue instanceof LocalDate) {
                this.setValueType(ValueType.DATE);
            } else if (!(sampleValue instanceof LocalDateTime) && !(sampleValue instanceof ZonedDateTime)) {
                throw new RuntimeException("can't convert property value to type: " + sampleValue.getClass().getSimpleName() + ". Accepted types are: " + this.allowedValueTypes);
            }
        }
        super.setValue(value);
    }

    @Override
    public List<String> errors() {
        List<String> errors = super.errors();
        Set recurrenceDates = (Set)this.getValue();
        if (recurrenceDates != null && !recurrenceDates.isEmpty()) {
            Temporal sampleTemporal = (Temporal)recurrenceDates.stream().findAny().get();
            DateTimeUtilities.DateTimeType sampleType = DateTimeUtilities.DateTimeType.of(sampleTemporal);
            Optional<DateTimeUtilities.DateTimeType> notMatchDateTimeType = recurrenceDates.stream().map(v -> DateTimeUtilities.DateTimeType.of(v)).filter(v -> !v.equals((Object)sampleType)).findAny();
            if (notMatchDateTimeType.isPresent()) {
                errors.add("Recurrences DateTimeType \"" + (Object)((Object)notMatchDateTimeType.get()) + "\" doesn't match previous recurrences DateTimeType \"" + sampleType + "\"");
            }
            if (sampleTemporal instanceof ZonedDateTime) {
                ZoneId zone = ((ZonedDateTime)sampleTemporal).getZone();
                Optional<ZoneId> notMatchZone = recurrenceDates.stream().map(t -> ((ZonedDateTime)t).getZone()).filter(z -> !z.equals(zone)).findAny();
                if (notMatchZone.isPresent()) {
                    errors.add("ZoneId \"" + notMatchZone.get() + "\" doesn't match previous ZoneId \"" + zone + "\"");
                }
            }
        }
        return errors;
    }

    @Override
    protected Set<Temporal> copyValue(Set<Temporal> source) {
        TreeSet<Temporal> newCollection = new TreeSet<Temporal>(DateTimeUtilities.TEMPORAL_COMPARATOR);
        newCollection.addAll(source);
        return newCollection;
    }
}

