/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.FrequencyType;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRulePartBase;

public class Frequency
extends RRulePartBase<FrequencyType, Frequency> {
    @Override
    void setValue(String frequency) {
        this.parseContent(frequency);
    }

    @Override
    public Frequency withValue(String frequency) {
        this.setValue(frequency);
        return this;
    }

    TemporalAdjuster adjuster(int interval) {
        return temporal -> temporal.plus(interval, ((FrequencyType)((Object)((Object)this.getValue()))).getChronoUnit());
    }

    public Frequency(FrequencyType frequencyType) {
        this();
        this.setValue(frequencyType);
    }

    public Frequency() {
    }

    public Frequency(Frequency source) {
        this();
        this.setValue((FrequencyType)((Object)source.getValue()));
    }

    public Stream<Temporal> streamRecurrences(Temporal start, int interval) {
        TemporalAdjuster adjuster = temporal -> temporal.plus(interval, ((FrequencyType)((Object)((Object)this.getValue()))).getChronoUnit());
        return Stream.iterate(start, a -> a.with(adjuster));
    }

    @Override
    protected List<VElementBase.Message> parseContent(String content) {
        String valueString = Frequency.extractValue(content);
        this.setValue(FrequencyType.valueOf(valueString.toUpperCase()));
        return Collections.EMPTY_LIST;
    }

    public static Frequency parse(String content) {
        return Frequency.parse(new Frequency(), content);
    }
}

