/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule;

import java.lang.reflect.Method;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.VParent;
import jfxtras.icalendarfx.VParentBase;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.Count;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.Frequency;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.FrequencyType;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.Interval;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.RRulePart;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.Until;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.WeekStart;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByDay;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRule;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRuleAbstract;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.icalendarfx.utilities.ICalendarUtilities;

public class RecurrenceRuleValue
extends VParentBase<RecurrenceRuleValue>
implements VChild {
    private VParent myParent;
    private static final String NAME = "RRULE";
    private List<ByRule<?>> byRules;
    private Count count;
    private Frequency frequency;
    private Interval interval;
    private Until until;
    private WeekStart weekStart;
    private ChronoUnit chronoUnit;
    private Stream<Temporal> myStream;

    @Override
    public void setParent(VParent parent) {
        this.myParent = parent;
    }

    @Override
    public VParent getParent() {
        return this.myParent;
    }

    @Override
    public String name() {
        return NAME;
    }

    public List<ByRule<?>> getByRules() {
        return this.byRules;
    }

    public void setByRules(List<ByRule<?>> byRules) {
        if (this.byRules != null) {
            this.byRules.forEach(e -> this.orderChild((VChild)e, null));
        }
        this.byRules = byRules;
        if (byRules != null) {
            byRules.forEach(e -> this.orderChild((VChild)e));
        }
    }

    public void setByRules(String ... byRules) {
        Arrays.stream(byRules).forEach(c -> this.parseContent((String)c));
    }

    public RecurrenceRuleValue withByRules(Collection<ByRule<?>> byRules) {
        if (this.getByRules() == null) {
            this.setByRules(new ArrayList());
        }
        this.getByRules().addAll(byRules);
        if (byRules != null) {
            byRules.forEach(c -> this.orderChild((VChild)c));
        }
        return this;
    }

    public RecurrenceRuleValue withByRules(ByRule<?> ... byRules) {
        return this.withByRules(Arrays.asList(byRules));
    }

    public RecurrenceRuleValue withByRules(String ... byRules) {
        this.setByRules(byRules);
        return this;
    }

    public ByRule<?> lookupByRule(Class<ByDay> class1) {
        if (this.getByRules() == null) {
            return null;
        }
        Optional<ByRule> byRule = this.getByRules().stream().filter(r -> r instanceof ByDay).findAny();
        if (!byRule.isPresent()) {
            return null;
        }
        return byRule.get();
    }

    public Count getCount() {
        return this.count;
    }

    public void setCount(Count count) {
        this.orderChild(this.count, (VChild)count);
        this.count = count;
    }

    public void setCount(int count) {
        this.setCount(new Count(count));
    }

    public RecurrenceRuleValue withCount(Count count) {
        this.setCount(count);
        return this;
    }

    public RecurrenceRuleValue withCount(int count) {
        this.setCount(count);
        return this;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Frequency frequency) {
        this.orderChild(this.frequency, (VChild)frequency);
        this.frequency = frequency;
    }

    public void setFrequency(String frequency) {
        this.setFrequency(Frequency.parse(frequency));
    }

    public void setFrequency(FrequencyType frequency) {
        this.setFrequency(new Frequency(frequency));
    }

    public RecurrenceRuleValue withFrequency(Frequency frequency) {
        this.setFrequency(frequency);
        return this;
    }

    public RecurrenceRuleValue withFrequency(String frequency) {
        this.setFrequency(frequency);
        return this;
    }

    public RecurrenceRuleValue withFrequency(FrequencyType frequency) {
        this.setFrequency(frequency);
        return this;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public void setInterval(Interval interval) {
        this.orderChild(this.interval, (VChild)interval);
        this.interval = interval;
    }

    public void setInterval(Integer interval) {
        this.setInterval(new Interval(interval));
    }

    public RecurrenceRuleValue withInterval(int interval) {
        this.setInterval(interval);
        return this;
    }

    public RecurrenceRuleValue withInterval(Interval interval) {
        this.setInterval(interval);
        return this;
    }

    public Until getUntil() {
        return this.until;
    }

    public void setUntil(Until until) {
        this.orderChild(this.until, (VChild)until);
        this.until = until;
    }

    public void setUntil(Temporal until) {
        this.setUntil(new Until(until));
    }

    public void setUntil(String until) {
        this.setUntil(DateTimeUtilities.temporalFromString(until));
    }

    public RecurrenceRuleValue withUntil(Temporal until) {
        this.setUntil(until);
        return this;
    }

    public RecurrenceRuleValue withUntil(String until) {
        this.setUntil(until);
        return this;
    }

    public RecurrenceRuleValue withUntil(Until until) {
        this.setUntil(until);
        return this;
    }

    public WeekStart getWeekStart() {
        return this.weekStart;
    }

    public void setWeekStart(WeekStart weekStart) {
        this.orderChild(this.weekStart, (VChild)weekStart);
        this.weekStart = weekStart;
    }

    public void setWeekStart(DayOfWeek weekStart) {
        this.setWeekStart(new WeekStart(weekStart));
    }

    public RecurrenceRuleValue withWeekStart(WeekStart weekStart) {
        this.setWeekStart(weekStart);
        return this;
    }

    public RecurrenceRuleValue withWeekStart(DayOfWeek weekStart) {
        this.setWeekStart(weekStart);
        return this;
    }

    @Override
    protected Method getSetter(VChild child) {
        Method setter = this.getSetters().get(child.getClass());
        if (setter == null && ByRule.class.isAssignableFrom(child.getClass())) {
            setter = this.getSetters().get(ByRule.class);
        }
        return setter;
    }

    @Override
    protected Method getGetter(VChild child) {
        Method getter = this.getGetters().get(child.getClass());
        if (getter == null && ByRule.class.isAssignableFrom(child.getClass())) {
            getter = this.getGetters().get(ByRule.class);
        }
        return getter;
    }

    public RecurrenceRuleValue() {
    }

    public RecurrenceRuleValue(RecurrenceRuleValue source) {
        super(source);
        this.setParent(source.getParent());
    }

    @Override
    protected List<VElementBase.Message> parseContent(String contentLine) {
        ArrayList<VElementBase.Message> messages = new ArrayList<VElementBase.Message>();
        ICalendarUtilities.parseInlineElementsToListPair(contentLine).stream().forEach(entry -> this.processInLineChild(messages, (String)entry.getKey(), (String)entry.getValue(), RRulePart.class));
        return messages;
    }

    public Stream<Temporal> streamRecurrences(Temporal start) {
        int interval = this.getInterval() == null ? 1 : (Integer)this.getInterval().getValue();
        Stream<Temporal> frequencyStream = this.getFrequency().streamRecurrences(start, interval);
        Stream<Temporal> recurrenceStream = frequencyStream.flatMap(value -> {
            this.chronoUnit = ((FrequencyType)((Object)((Object)this.getFrequency().getValue()))).getChronoUnit();
            this.myStream = Arrays.asList(value).stream();
            if (this.getByRules() != null) {
                this.getByRules().stream().sorted().forEach(rule -> {
                    this.myStream = rule.streamRecurrences(this.myStream, this.chronoUnit, start);
                    this.chronoUnit = ((ByRuleAbstract)rule).elementType.getChronoUnit();
                });
            }
            return this.myStream.filter(r -> !DateTimeUtilities.isBefore(r, start));
        });
        if (this.getCount() != null) {
            return recurrenceStream.limit(((Integer)this.getCount().getValue()).intValue());
        }
        if (this.getUntil() != null) {
            ZoneId zone = start instanceof ZonedDateTime ? ((ZonedDateTime)start).getZone() : null;
            Temporal convertedUntil = DateTimeUtilities.DateTimeType.of(start).from((Temporal)this.getUntil().getValue(), zone);
            return RecurrenceRuleValue.takeWhile(recurrenceStream, (? super T a) -> !DateTimeUtilities.isAfter(a, convertedUntil));
        }
        return recurrenceStream;
    }

    public boolean isInfinite() {
        return this.getCount() == null && this.getUntil() == null;
    }

    static <T> Spliterator<T> takeWhile(final Spliterator<T> splitr, final Predicate<? super T> predicate) {
        return new Spliterators.AbstractSpliterator<T>(splitr.estimateSize(), 0){
            boolean stillGoing;
            {
                super(x0, x1);
                this.stillGoing = true;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.stillGoing) {
                    boolean hadNext = splitr.tryAdvance(elem -> {
                        if (predicate.test(elem)) {
                            consumer.accept(elem);
                        } else {
                            this.stillGoing = false;
                        }
                    });
                    return hadNext && this.stillGoing;
                }
                return false;
            }
        };
    }

    static <T> Stream<T> takeWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamSupport.stream(RecurrenceRuleValue.takeWhile(stream.spliterator(), predicate), false);
    }

    @Override
    public String toString() {
        return this.childrenUnmodifiable().stream().map(c -> c.toString()).collect(Collectors.joining(";"));
    }

    @Override
    public List<String> errors() {
        boolean isCountPresent;
        List<String> errors = super.errors();
        if (this.getFrequency() == null) {
            errors.add(this.name() + ":FREQ is not present.  FREQ is REQUIRED and MUST NOT occur more than once");
        }
        if (this.getByRules() != null) {
            this.getByRules().stream().collect(Collectors.groupingBy(Object::getClass, Collectors.counting()));
        }
        boolean isUntilPresent = this.getUntil() != null;
        boolean bl = isCountPresent = this.getCount() != null;
        if (isUntilPresent && isCountPresent) {
            errors.add(this.name() + ":UNTIL and COUNT are both present.  UNTIL or COUNT rule parts are OPTIONAL, but they MUST NOT both occur.");
        }
        ArrayList byRules = this.getByRules() == null ? Collections.emptyList() : new ArrayList(this.getByRules());
        List duplicateByRuleMessages = byRules.stream().collect(Collectors.groupingBy(Object::getClass, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(e -> this.name() + ":" + ((Class)e.getKey()).getSimpleName() + " can only occur once in a RRULE.").collect(Collectors.toList());
        errors.addAll(duplicateByRuleMessages);
        return errors;
    }

    @Override
    protected boolean checkChild(List<VElementBase.Message> messages, String content, String elementName, VChild newChild) {
        boolean isSuperOk = super.checkChild(messages, content, elementName, newChild);
        if (newChild instanceof ByRule) {
            ArrayList<ByRule> byRules = this.getByRules() == null ? new ArrayList<ByRule>() : new ArrayList(this.getByRules());
            byRules.add((ByRule)newChild);
            List duplicateByRuleMessages = byRules.stream().collect(Collectors.groupingBy(Object::getClass, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(e -> new VElementBase.Message(this, newChild.getClass().getSimpleName() + " can only occur once in a calendar component.", VElementBase.MessageEffect.MESSAGE_ONLY)).collect(Collectors.toList());
            boolean isDuplicateByRulePresent = duplicateByRuleMessages.isEmpty();
            messages.addAll(duplicateByRuleMessages);
            return isSuperOk && isDuplicateByRulePresent;
        }
        return isSuperOk;
    }

    public static RecurrenceRuleValue parse(String content) {
        return RecurrenceRuleValue.parse(new RecurrenceRuleValue(), content);
    }
}

