/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx;

import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jfxtras.icalendarfx.properties.component.recurrence.rrule.byxxx.ByRuleIntegerAbstract;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;

public class ByMonthDay
extends ByRuleIntegerAbstract<ByMonthDay> {
    public ByMonthDay() {
    }

    public ByMonthDay(Integer ... daysOfMonth) {
        super(daysOfMonth);
    }

    public ByMonthDay(ByMonthDay source) {
        super(source);
    }

    @Override
    Predicate<Integer> isValidValue() {
        return value -> value >= -31 && value <= 31 && value != 0;
    }

    @Override
    public Stream<Temporal> streamRecurrences(Stream<Temporal> inStream, ChronoUnit chronoUnit, Temporal dateTimeStart) {
        switch (chronoUnit) {
            case HOURS: 
            case MINUTES: 
            case SECONDS: 
            case DAYS: {
                return inStream.filter(d -> {
                    int myDay = d.get(ChronoField.DAY_OF_MONTH);
                    int myDaysInMonth = LocalDate.from(d).lengthOfMonth();
                    Iterator iterator = ((List)this.getValue()).iterator();
                    while (iterator.hasNext()) {
                        int day = (Integer)iterator.next();
                        if (myDay == day) {
                            return true;
                        }
                        if (day >= 0 || myDay != myDaysInMonth + day + 1) continue;
                        return true;
                    }
                    return false;
                });
            }
            case YEARS: {
                return inStream.flatMap(d -> {
                    ArrayList<Temporal> dates = new ArrayList<Temporal>();
                    for (Month month : Month.values()) {
                        Temporal monthAdjustedTemporal = d.with(ChronoField.MONTH_OF_YEAR, month.getValue());
                        dates.addAll(this.extracted(monthAdjustedTemporal, dateTimeStart));
                    }
                    return dates.stream().sorted(DateTimeUtilities.TEMPORAL_COMPARATOR);
                });
            }
            case MONTHS: {
                return inStream.flatMap(d -> {
                    ArrayList<Temporal> dates = new ArrayList<Temporal>();
                    dates.addAll(this.extracted((Temporal)d, dateTimeStart));
                    return dates.stream().sorted(DateTimeUtilities.TEMPORAL_COMPARATOR);
                });
            }
            case WEEKS: {
                throw new IllegalArgumentException(this.name().toString() + " is not available for " + chronoUnit + " frequency.");
            }
        }
        throw new IllegalArgumentException("Not implemented: " + chronoUnit);
    }

    private List<Temporal> extracted(Temporal initialTemporal, Temporal dateTimeStart) {
        ArrayList<Temporal> dates = new ArrayList<Temporal>();
        Iterator iterator = ((List)this.getValue()).iterator();
        while (iterator.hasNext()) {
            Temporal newTemporal;
            int dayOfMonth = (Integer)iterator.next();
            Temporal correctMonthTemporal = dayOfMonth > 0 ? initialTemporal : initialTemporal.minus(1L, ChronoUnit.MONTHS);
            int daysInMonth = (int)ChronoUnit.DAYS.between(correctMonthTemporal.with(TemporalAdjusters.firstDayOfMonth()), correctMonthTemporal.with(TemporalAdjusters.firstDayOfNextMonth()));
            int finalDayOfMonth = 0;
            if (dayOfMonth > 0) {
                if (dayOfMonth <= daysInMonth) {
                    finalDayOfMonth = dayOfMonth;
                }
            } else if (dayOfMonth < 0) {
                int newDayOfMonth = daysInMonth + dayOfMonth + 1;
                if (newDayOfMonth > 0) {
                    finalDayOfMonth = newDayOfMonth;
                }
            } else {
                throw new IllegalArgumentException(this.name().toString() + " can't have a value of zero");
            }
            if ((newTemporal = finalDayOfMonth != 0 ? correctMonthTemporal.with(ChronoField.DAY_OF_MONTH, finalDayOfMonth) : null) == null) continue;
            dates.add(newTemporal);
        }
        return dates;
    }

    public static ByMonthDay parse(String content) {
        return ByMonthDay.parse(new ByMonthDay(), content);
    }
}

